/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.deserialization.deserializers.customprimitives;

import de.quantummaid.mapmaid.debug.DebugInformation;
import de.quantummaid.mapmaid.mapper.deserialization.DeserializerCallback;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.validation.ExceptionTracker;
import de.quantummaid.mapmaid.mapper.injector.Injector;
import de.quantummaid.mapmaid.mapper.schema.PrimitiveSchemaMappings;
import de.quantummaid.mapmaid.mapper.schema.SchemaCallback;
import de.quantummaid.mapmaid.mapper.universal.Universal;
import de.quantummaid.mapmaid.mapper.universal.UniversalNull;
import de.quantummaid.mapmaid.mapper.universal.UniversalPrimitive;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.mapmaid.shared.mapping.CustomPrimitiveMappings;
import java.util.Collections;
import java.util.List;

public interface CustomPrimitiveDeserializer
extends TypeDeserializer {
    public static String createDescription(CustomPrimitiveDeserializer customPrimitiveDeserializer, String deserializer) {
        Class<?> baseType = customPrimitiveDeserializer.baseType();
        return String.format("as custom primitive based on type '%s' using %s", baseType.getSimpleName(), deserializer);
    }

    @Override
    default public List<TypeIdentifier> requiredTypes() {
        return Collections.emptyList();
    }

    default public Class<?> baseType() {
        return String.class;
    }

    public Object deserialize(Object var1) throws Exception;

    @Override
    default public <T> T deserialize(Universal input, ExceptionTracker exceptionTracker, Injector injector, DeserializerCallback callback, CustomPrimitiveMappings customPrimitiveMappings, TypeIdentifier typeIdentifier, DebugInformation debugInformation) {
        if (input instanceof UniversalNull) {
            return null;
        }
        UniversalPrimitive universalPrimitive = TypeDeserializer.castSafely(input, UniversalPrimitive.class, exceptionTracker, typeIdentifier, debugInformation);
        try {
            Class<?> baseType = this.baseType();
            Object mapped = customPrimitiveMappings.fromUniversal(universalPrimitive, baseType);
            return (T)this.deserialize(mapped);
        }
        catch (Exception e) {
            String message = String.format("Exception calling deserialize(input: %s)", input.toNativeJava());
            exceptionTracker.track(e, message);
            return null;
        }
    }

    @Override
    default public Universal schema(SchemaCallback schemaCallback) {
        Class<?> baseType = this.baseType();
        return PrimitiveSchemaMappings.mapPrimitiveToSchema(baseType);
    }
}

