/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.deserialization.validation;

import de.quantummaid.mapmaid.mapper.deserialization.validation.ValidationError;
import java.util.Collections;
import java.util.List;

public final class AggregatedValidationException
extends RuntimeException {
    private final List<ValidationError> validationErrors;

    private AggregatedValidationException(String msg, List<ValidationError> validationErrors) {
        super(msg);
        this.validationErrors = Collections.unmodifiableList(validationErrors);
    }

    public static AggregatedValidationException fromList(List<ValidationError> validationErrors) {
        StringBuilder sb = new StringBuilder("deserialization encountered validation errors. ");
        for (ValidationError entry : validationErrors) {
            sb.append(String.format("Validation error at '%s', %s; ", entry.propertyPath, entry.message));
        }
        return new AggregatedValidationException(sb.toString(), validationErrors);
    }

    public List<ValidationError> getValidationErrors() {
        return Collections.unmodifiableList(this.validationErrors);
    }
}

