/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.schema;

import de.quantummaid.mapmaid.mapper.schema.SchemaCallback;
import de.quantummaid.mapmaid.mapper.universal.Universal;
import de.quantummaid.mapmaid.mapper.universal.UniversalObject;
import de.quantummaid.mapmaid.mapper.universal.UniversalString;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SchemaSupport {
    private SchemaSupport() {
    }

    public static Universal schemaForObject(Map<String, TypeIdentifier> fields, SchemaCallback schemaCallback) {
        LinkedHashMap<String, Universal> properties = new LinkedHashMap<String, Universal>(fields.size());
        fields.forEach((key, typeIdentifier) -> {
            Universal childSchema = schemaCallback.schema((TypeIdentifier)typeIdentifier);
            properties.put((String)key, childSchema);
        });
        HashMap<String, Universal> map = new HashMap<String, Universal>();
        map.put("type", UniversalString.universalString("object"));
        map.put("properties", UniversalObject.universalObject(properties));
        return UniversalObject.universalObject(map);
    }

    public static Universal schemaForCollection(TypeIdentifier contentType, SchemaCallback schemaCallback) {
        LinkedHashMap<String, Universal> map = new LinkedHashMap<String, Universal>();
        map.put("type", UniversalString.universalString("array"));
        Universal contentTypeSchema = schemaCallback.schema(contentType);
        map.put("items", contentTypeSchema);
        return UniversalObject.universalObject(map);
    }
}

