/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.serialization.serializers.customprimitives;

import de.quantummaid.mapmaid.debug.MapMaidException;
import de.quantummaid.mapmaid.debug.scaninformation.ScanInformation;
import de.quantummaid.mapmaid.mapper.serialization.serializers.customprimitives.CustomPrimitiveSerializer;
import de.quantummaid.reflectmaid.ResolvedType;
import de.quantummaid.reflectmaid.resolver.ResolvedMethod;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import lombok.Generated;

public final class MethodCustomPrimitiveSerializer
implements CustomPrimitiveSerializer {
    private final ResolvedType baseType;
    private final ResolvedMethod serializationMethod;

    public static CustomPrimitiveSerializer createSerializer(ResolvedType type, ResolvedMethod serializationMethod) {
        int serializationMethodModifiers = serializationMethod.method().getModifiers();
        if (Modifier.isStatic(serializationMethodModifiers)) {
            throw MapMaidException.mapMaidException(String.format("The serialization method %s configured for the custom primitive of type %s must not be static", serializationMethod, type.description()), new ScanInformation[0]);
        }
        if (!serializationMethod.parameters().isEmpty()) {
            throw MapMaidException.mapMaidException(String.format("The serialization method %s configured for the custom primitive of type %s must not accept any parameters", serializationMethod.describe(), type.description()), new ScanInformation[0]);
        }
        ResolvedType baseType = serializationMethod.returnType().orElseThrow(() -> MapMaidException.mapMaidException(String.format("The serialization method %s configured for the custom primitive of type %s must not be void", serializationMethod, type.description()), new ScanInformation[0]));
        return new MethodCustomPrimitiveSerializer(baseType, serializationMethod);
    }

    @Override
    public Object serialize(Object object) {
        try {
            return this.serializationMethod.method().invoke(object, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw MapMaidException.mapMaidException(String.format("This should never happen. Called serialization method %s for custom type %s on instance %s", this.serializationMethod, object.getClass(), object), (Exception)e, new ScanInformation[0]);
        }
        catch (InvocationTargetException e) {
            throw MapMaidException.mapMaidException(String.format("Got exception calling serialization method %s for custom type %s on instance %s", this.serializationMethod, object.getClass(), object), (Exception)e, new ScanInformation[0]);
        }
    }

    @Override
    public Class<?> baseType() {
        return this.baseType.assignableType();
    }

    public ResolvedMethod method() {
        return this.serializationMethod;
    }

    @Override
    public String description() {
        return String.format("as custom primitive using %s", this.serializationMethod.describe());
    }

    @Generated
    public String toString() {
        return "MethodCustomPrimitiveSerializer(baseType=" + this.baseType + ", serializationMethod=" + this.serializationMethod + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodCustomPrimitiveSerializer)) {
            return false;
        }
        MethodCustomPrimitiveSerializer other = (MethodCustomPrimitiveSerializer)o;
        ResolvedType this$baseType = this.baseType;
        ResolvedType other$baseType = other.baseType;
        if (this$baseType == null ? other$baseType != null : !this$baseType.equals(other$baseType)) {
            return false;
        }
        ResolvedMethod this$serializationMethod = this.serializationMethod;
        ResolvedMethod other$serializationMethod = other.serializationMethod;
        return !(this$serializationMethod == null ? other$serializationMethod != null : !((Object)this$serializationMethod).equals(other$serializationMethod));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResolvedType $baseType = this.baseType;
        result = result * 59 + ($baseType == null ? 43 : $baseType.hashCode());
        ResolvedMethod $serializationMethod = this.serializationMethod;
        result = result * 59 + ($serializationMethod == null ? 43 : ((Object)$serializationMethod).hashCode());
        return result;
    }

    @Generated
    private MethodCustomPrimitiveSerializer(ResolvedType baseType, ResolvedMethod serializationMethod) {
        this.baseType = baseType;
        this.serializationMethod = serializationMethod;
    }
}

