/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.universal;

import de.quantummaid.mapmaid.debug.MapMaidException;
import de.quantummaid.mapmaid.debug.scaninformation.ScanInformation;
import de.quantummaid.mapmaid.mapper.universal.UniversalLong;
import de.quantummaid.mapmaid.mapper.universal.UniversalPrimitive;
import de.quantummaid.mapmaid.mapper.universal.UniversalString;
import lombok.Generated;

public final class UniversalDouble
implements UniversalPrimitive {
    private final double value;

    public static UniversalDouble universalDouble(double value) {
        return new UniversalDouble(value);
    }

    public static UniversalDouble universalDoubleFromUniversalString(UniversalString universalString) {
        String stringValue = (String)universalString.toNativeJava();
        return UniversalDouble.universalDoubleFromString(stringValue);
    }

    private static UniversalDouble universalDoubleFromString(String stringValue) {
        Double doubleValue = Double.parseDouble(stringValue);
        return UniversalDouble.universalDouble(doubleValue);
    }

    public static UniversalDouble universalDoubleFromUniversalLong(UniversalLong universalLong) {
        Long longValue = (Long)universalLong.toNativeJava();
        return UniversalDouble.universalDoubleFromLong(longValue);
    }

    private static UniversalDouble universalDoubleFromLong(Long longValue) {
        double value = longValue.doubleValue();
        return UniversalDouble.universalDouble(value);
    }

    @Override
    public Object toNativeJava() {
        return this.value;
    }

    public float toNativeFloatExact() {
        String doubleStringRepresentation;
        float floatValue = (float)this.value;
        Float wrappedFloat = Float.valueOf(floatValue);
        Double wrappedDouble = this.value;
        String floatStringRepresentation = wrappedFloat.toString();
        if (!floatStringRepresentation.equals(doubleStringRepresentation = wrappedDouble.toString())) {
            String message = String.format("Overflow when converting double '%s' to float.", this.value);
            throw MapMaidException.mapMaidException(message, new ScanInformation[0]);
        }
        return floatValue;
    }

    public double toNativeDouble() {
        return this.value;
    }

    @Generated
    public String toString() {
        return "UniversalDouble(value=" + this.value + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UniversalDouble)) {
            return false;
        }
        UniversalDouble other = (UniversalDouble)o;
        return Double.compare(this.value, other.value) == 0;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $value = Double.doubleToLongBits(this.value);
        result = result * 59 + (int)($value >>> 32 ^ $value);
        return result;
    }

    @Generated
    private UniversalDouble(double value) {
        this.value = value;
    }
}

