/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.universal;

import de.quantummaid.mapmaid.debug.MapMaidException;
import de.quantummaid.mapmaid.debug.scaninformation.ScanInformation;
import de.quantummaid.mapmaid.mapper.universal.UniversalDouble;
import de.quantummaid.mapmaid.mapper.universal.UniversalPrimitive;
import de.quantummaid.mapmaid.mapper.universal.UniversalString;
import lombok.Generated;

public final class UniversalLong
implements UniversalPrimitive {
    private final long value;

    public static UniversalLong universalLong(long value) {
        return new UniversalLong(value);
    }

    public static UniversalLong universalLongFromUniversalDouble(UniversalDouble universalDouble) {
        Double o = (Double)universalDouble.toNativeJava();
        return UniversalLong.universalLongFromDouble(o);
    }

    public static UniversalLong universalLongFromDouble(Double value) {
        if (UniversalLong.isNonFractionalDouble(value)) {
            return UniversalLong.universalLong(value.longValue());
        }
        String message = String.format("Cannot cast double '%s' to long", value);
        throw MapMaidException.mapMaidException(message, new ScanInformation[0]);
    }

    public static UniversalLong universalLongFromUniversalString(UniversalString universalString) {
        String stringValue = (String)universalString.toNativeJava();
        return UniversalLong.universalLongFromString(stringValue);
    }

    public static UniversalLong universalLongFromString(String value) {
        Long longValue = Long.parseLong(value);
        return UniversalLong.universalLong(longValue);
    }

    private static boolean isNonFractionalDouble(Double value) {
        return Math.rint(value) == value;
    }

    @Override
    public Object toNativeJava() {
        return this.value;
    }

    public long toNativeLong() {
        return this.value;
    }

    public int toNativeIntExact() {
        if ((long)((int)this.value) != this.value) {
            String message = String.format("Overflow when converting long '%d' to int.", this.value);
            throw MapMaidException.mapMaidException(message, new ScanInformation[0]);
        }
        return (int)this.value;
    }

    public short toNativeShortExact() {
        if ((long)((short)this.value) != this.value) {
            String message = String.format("Overflow when converting long '%d' to short.", this.value);
            throw MapMaidException.mapMaidException(message, new ScanInformation[0]);
        }
        return (short)this.value;
    }

    public byte toNativeByteExact() {
        if ((long)((byte)this.value) != this.value) {
            String message = String.format("Overflow when converting long '%d' to byte.", this.value);
            throw MapMaidException.mapMaidException(message, new ScanInformation[0]);
        }
        return (byte)this.value;
    }

    @Generated
    public String toString() {
        return "UniversalLong(value=" + this.value + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UniversalLong)) {
            return false;
        }
        UniversalLong other = (UniversalLong)o;
        return this.value == other.value;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $value = this.value;
        result = result * 59 + (int)($value >>> 32 ^ $value);
        return result;
    }

    @Generated
    private UniversalLong(long value) {
        this.value = value;
    }
}

