/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.messagebus.internal;

import de.quantummaid.eventmaid.channel.Channel;
import de.quantummaid.eventmaid.messagebus.MessageBusStatusInformation;
import de.quantummaid.eventmaid.messagebus.exception.MessageBusExceptionListener;
import de.quantummaid.eventmaid.messagebus.internal.brokering.MessageBusBrokerStrategy;
import de.quantummaid.eventmaid.messagebus.internal.exception.ExceptionListenerHandler;
import de.quantummaid.eventmaid.messagebus.internal.statistics.MessageBusStatisticsCollector;
import de.quantummaid.eventmaid.messagebus.statistics.MessageBusStatistics;
import de.quantummaid.eventmaid.processingcontext.EventType;
import de.quantummaid.eventmaid.subscribing.Subscriber;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;

public final class MessageBusStatusInformationAdapter
implements MessageBusStatusInformation {
    private final MessageBusStatisticsCollector statisticsCollector;
    private final MessageBusBrokerStrategy brokerStrategy;
    private final ExceptionListenerHandler exceptionListenerHandler;

    public static MessageBusStatusInformationAdapter statusInformationAdapter(@NonNull MessageBusStatisticsCollector statisticsCollector, @NonNull MessageBusBrokerStrategy brokerStrategy, @NonNull ExceptionListenerHandler exceptionListenerHandler) {
        if (statisticsCollector == null) {
            throw new NullPointerException("statisticsCollector is marked non-null but is null");
        }
        if (brokerStrategy == null) {
            throw new NullPointerException("brokerStrategy is marked non-null but is null");
        }
        if (exceptionListenerHandler == null) {
            throw new NullPointerException("exceptionListenerHandler is marked non-null but is null");
        }
        return new MessageBusStatusInformationAdapter(statisticsCollector, brokerStrategy, exceptionListenerHandler);
    }

    @Override
    public MessageBusStatistics getCurrentMessageStatistics() {
        return this.statisticsCollector.getStatistics();
    }

    @Override
    public List<Subscriber<?>> getAllSubscribers() {
        return this.brokerStrategy.getAllSubscribers();
    }

    @Override
    public Channel<Object> getChannelFor(EventType eventType) {
        return this.brokerStrategy.getDeliveringChannelFor(eventType);
    }

    @Override
    public Map<EventType, List<Subscriber<?>>> getSubscribersPerType() {
        return this.brokerStrategy.getSubscribersPerType();
    }

    @Override
    public List<MessageBusExceptionListener> getAllExceptionListener() {
        return this.exceptionListenerHandler.allListener();
    }

    @Generated
    private MessageBusStatusInformationAdapter(MessageBusStatisticsCollector statisticsCollector, MessageBusBrokerStrategy brokerStrategy, ExceptionListenerHandler exceptionListenerHandler) {
        this.statisticsCollector = statisticsCollector;
        this.brokerStrategy = brokerStrategy;
        this.exceptionListenerHandler = exceptionListenerHandler;
    }
}

