/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.messagefunction.internal;

import de.quantummaid.eventmaid.messagebus.MessageBus;
import de.quantummaid.eventmaid.subscribing.SubscriptionId;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;

public final class SubscriptionContainer {
    private final MessageBus messageBus;
    private final AtomicReference<SubscriptionId> answerSubscriptionIdRef = new AtomicReference<Object>(null);
    private final AtomicReference<SubscriptionId> errorSubscriptionId1Ref = new AtomicReference<Object>(null);
    private final AtomicReference<SubscriptionId> errorSubscriptionId2Ref = new AtomicReference<Object>(null);

    public static SubscriptionContainer subscriptionContainer(MessageBus messageBus) {
        return new SubscriptionContainer(messageBus);
    }

    public synchronized void setSubscriptionIds(SubscriptionId answerSubscriptionId, SubscriptionId errorSubscriptionId1, SubscriptionId errorSubscriptionId2) {
        this.answerSubscriptionIdRef.set(answerSubscriptionId);
        this.errorSubscriptionId1Ref.set(errorSubscriptionId1);
        this.errorSubscriptionId2Ref.set(errorSubscriptionId2);
    }

    public void unsubscribe() {
        SubscriptionId errorSubscriptionId2;
        SubscriptionId errorSubscriptionId1;
        SubscriptionId answerSubscription = this.answerSubscriptionIdRef.get();
        if (answerSubscription != null) {
            this.messageBus.unsubcribe(answerSubscription);
        }
        if ((errorSubscriptionId1 = this.errorSubscriptionId1Ref.get()) != null) {
            this.messageBus.unregisterExceptionListener(errorSubscriptionId1);
        }
        if ((errorSubscriptionId2 = this.errorSubscriptionId2Ref.get()) != null) {
            this.messageBus.unregisterExceptionListener(errorSubscriptionId2);
        }
    }

    @Generated
    SubscriptionContainer(MessageBus messageBus) {
        this.messageBus = messageBus;
    }
}

