/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.qcec.queryresolving;

import de.quantummaid.eventmaid.messagebus.MessageBus;
import de.quantummaid.eventmaid.processingcontext.EventType;
import de.quantummaid.eventmaid.qcec.queryresolving.Query;
import de.quantummaid.eventmaid.qcec.queryresolving.QueryResolver;
import de.quantummaid.eventmaid.subscribing.PreemptiveSubscriber;
import de.quantummaid.eventmaid.subscribing.SubscriptionId;
import java.util.Optional;
import java.util.function.Consumer;

public class QueryResolverImpl
implements QueryResolver {
    private final MessageBus messageBus;

    QueryResolverImpl(MessageBus messageBus) {
        this.messageBus = messageBus;
    }

    @Override
    public <T extends Query<?>> SubscriptionId answer(Class<T> queryClass, Consumer<T> responder) {
        PreemptiveSubscriber<Object> subscriber = PreemptiveSubscriber.preemptiveSubscriber(t -> {
            Query query = (Query)t;
            responder.accept(query);
            return !query.finished();
        });
        EventType eventType = EventType.eventTypeFromClass(queryClass);
        this.messageBus.subscribe(eventType, subscriber);
        return subscriber.getSubscriptionId();
    }

    @Override
    public <R> Optional<R> query(Query<R> query) {
        EventType eventType = EventType.eventTypeFromObjectClass(query);
        this.messageBus.send(eventType, query);
        return Optional.ofNullable(query.result());
    }

    @Override
    public <R> R queryRequired(Query<R> query) {
        EventType eventType = EventType.eventTypeFromObjectClass(query);
        this.messageBus.send(eventType, query);
        return Optional.ofNullable(query.result()).orElseThrow(() -> new UnsupportedOperationException("Expected a query result for query " + query));
    }

    @Override
    public void unsubscribe(SubscriptionId subscriptionId) {
        this.messageBus.unsubcribe(subscriptionId);
    }
}

