/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.events;

import de.quantummaid.httpmaid.events.enriching.EnrichableMap;
import de.quantummaid.httpmaid.events.enriching.Injection;
import de.quantummaid.httpmaid.util.Validators;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public final class Event {
    private final EnrichableMap map;
    private final List<Injection> injections;
    private final List<Object> typeInjections;

    public static Event event(EnrichableMap map) {
        return new Event(map, new ArrayList<Injection>(), new ArrayList<Object>());
    }

    public void addInjection(String key, String value) {
        Injection injection = Injection.injection(key, value);
        this.injections.add(injection);
    }

    public void addTypeInjection(Object injection) {
        Validators.validateNotNull(injection, "injection");
        this.typeInjections.add(injection);
    }

    public Map<String, Object> asMap() {
        return this.map.asMap();
    }

    public List<Injection> injections() {
        return Collections.unmodifiableList(this.injections);
    }

    public List<Object> typeInjections() {
        return Collections.unmodifiableList(this.typeInjections);
    }

    @Generated
    public String toString() {
        return "Event(map=" + this.map + ", injections=" + this.injections + ", typeInjections=" + this.typeInjections + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event other = (Event)o;
        EnrichableMap this$map = this.map;
        EnrichableMap other$map = other.map;
        if (this$map == null ? other$map != null : !((Object)this$map).equals(other$map)) {
            return false;
        }
        List<Injection> this$injections = this.injections;
        List<Injection> other$injections = other.injections;
        if (this$injections == null ? other$injections != null : !((Object)this$injections).equals(other$injections)) {
            return false;
        }
        List<Object> this$typeInjections = this.typeInjections;
        List<Object> other$typeInjections = other.typeInjections;
        return !(this$typeInjections == null ? other$typeInjections != null : !((Object)this$typeInjections).equals(other$typeInjections));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EnrichableMap $map = this.map;
        result = result * 59 + ($map == null ? 43 : ((Object)$map).hashCode());
        List<Injection> $injections = this.injections;
        result = result * 59 + ($injections == null ? 43 : ((Object)$injections).hashCode());
        List<Object> $typeInjections = this.typeInjections;
        result = result * 59 + ($typeInjections == null ? 43 : ((Object)$typeInjections).hashCode());
        return result;
    }

    @Generated
    private Event(EnrichableMap map, List<Injection> injections, List<Object> typeInjections) {
        this.map = map;
        this.injections = injections;
        this.typeInjections = typeInjections;
    }
}

