/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.http;

import de.quantummaid.httpmaid.http.HttpRequestException;
import de.quantummaid.httpmaid.http.QueryParameter;
import de.quantummaid.httpmaid.http.QueryParameterName;
import de.quantummaid.httpmaid.http.QueryParameterValue;
import de.quantummaid.httpmaid.http.QueryParametersBuilder;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public final class QueryParameters {
    private static final QueryParameters EMPTY = new QueryParameters(Collections.emptyList());
    private final List<QueryParameter> queryParameters;

    public static QueryParametersBuilder builder() {
        return new QueryParametersBuilder();
    }

    public static QueryParameters queryParameters(List<QueryParameter> parameters) {
        return new QueryParameters(List.copyOf(parameters));
    }

    public static QueryParameters fromQueryString(String queryString) {
        if (queryString == null || queryString.isEmpty()) {
            return EMPTY;
        }
        ArrayList<QueryParameter> queryParameters = new ArrayList<QueryParameter>();
        for (String param : queryString.split("&")) {
            String[] entry = param.split("=");
            QueryParameterName name = QueryParameterName.queryParameterName(QueryParameters.decode(entry[0]));
            QueryParameterValue value = entry.length > 1 ? QueryParameterValue.queryParameterValue(QueryParameters.decode(entry[1])) : QueryParameterValue.queryParameterValue("");
            queryParameters.add(QueryParameter.queryParameter(name, value));
        }
        return QueryParameters.queryParameters(queryParameters);
    }

    private static String decode(String s) {
        return URLDecoder.decode(s, StandardCharsets.UTF_8);
    }

    public String parameter(String name) {
        return this.optionalParameter(name).orElseThrow(() -> HttpRequestException.httpHandlerException(String.format("No query parameter with the name '%s'", name)));
    }

    public Optional<String> optionalParameter(String name) {
        QueryParameterName requestedName = QueryParameterName.queryParameterName(name);
        List found = this.queryParameters.stream().filter(queryParameter -> queryParameter.name().equals(requestedName)).map(queryParameter -> queryParameter.value().stringValue()).collect(Collectors.toList());
        if (found.isEmpty()) {
            return Optional.empty();
        }
        if (found.size() > 1) {
            String joinedValues = String.join((CharSequence)", ", found);
            throw HttpRequestException.httpHandlerException(String.format("Expecting query string parameter '%s' to only have one value but got [%s]", name, joinedValues));
        }
        return Optional.of((String)found.get(0));
    }

    public Map<String, List<String>> asMap() {
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
        this.queryParameters.forEach(queryParameter -> {
            String name = queryParameter.name().stringValue();
            String value = queryParameter.value().stringValue();
            List values = result.getOrDefault(name, new ArrayList());
            values.add(value);
            result.put(name, values);
        });
        return result;
    }

    public List<QueryParameter> asList() {
        return Collections.unmodifiableList(this.queryParameters);
    }

    public List<String> allValuesFor(String name) {
        QueryParameterName parameterName = QueryParameterName.queryParameterName(name);
        return this.queryParameters.stream().filter(parameter -> parameterName.equals(parameter.name())).map(QueryParameter::value).map(QueryParameterValue::stringValue).collect(Collectors.toList());
    }

    @Generated
    public String toString() {
        return "QueryParameters(queryParameters=" + this.queryParameters + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryParameters)) {
            return false;
        }
        QueryParameters other = (QueryParameters)o;
        List<QueryParameter> this$queryParameters = this.queryParameters;
        List<QueryParameter> other$queryParameters = other.queryParameters;
        return !(this$queryParameters == null ? other$queryParameters != null : !((Object)this$queryParameters).equals(other$queryParameters));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<QueryParameter> $queryParameters = this.queryParameters;
        result = result * 59 + ($queryParameters == null ? 43 : ((Object)$queryParameters).hashCode());
        return result;
    }

    @Generated
    private QueryParameters(List<QueryParameter> queryParameters) {
        this.queryParameters = queryParameters;
    }
}

