/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.http.headers.accept;

import de.quantummaid.httpmaid.http.headers.HeaderValueWithComment;
import de.quantummaid.httpmaid.util.Validators;
import lombok.Generated;

public final class MimeType {
    private final String type;
    private final String subtype;

    static MimeType parseMimeType(String string) {
        Validators.validateNotNullNorEmpty(string, "string");
        HeaderValueWithComment value = HeaderValueWithComment.fromString(string);
        String typeAndSubtype = value.value();
        if (!typeAndSubtype.contains("/")) {
            return new MimeType(typeAndSubtype, "");
        }
        int slash = typeAndSubtype.indexOf(47);
        String type = typeAndSubtype.substring(0, slash).toLowerCase();
        String subtype = typeAndSubtype.substring(slash + 1);
        return new MimeType(type, subtype);
    }

    public String type() {
        return this.type;
    }

    public String subtype() {
        return this.subtype;
    }

    @Generated
    public String toString() {
        return "MimeType(type=" + this.type + ", subtype=" + this.subtype + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MimeType)) {
            return false;
        }
        MimeType other = (MimeType)o;
        String this$type = this.type;
        String other$type = other.type;
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$subtype = this.subtype;
        String other$subtype = other.subtype;
        return !(this$subtype == null ? other$subtype != null : !this$subtype.equals(other$subtype));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $subtype = this.subtype;
        result = result * 59 + ($subtype == null ? 43 : $subtype.hashCode());
        return result;
    }

    @Generated
    private MimeType(String type, String subtype) {
        this.type = type;
        this.subtype = subtype;
    }
}

