/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.marshalling.processors;

import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.Processor;
import de.quantummaid.httpmaid.handler.http.HttpRequest;
import de.quantummaid.httpmaid.http.headers.ContentType;
import de.quantummaid.httpmaid.marshalling.DefaultContentTypeProvider;
import de.quantummaid.httpmaid.marshalling.Unmarshaller;
import de.quantummaid.httpmaid.marshalling.Unmarshallers;
import de.quantummaid.httpmaid.marshalling.UnsupportedContentTypeException;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UnmarshalProcessor
implements Processor {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnmarshalProcessor.class);
    private final Unmarshallers unmarshallersMap;
    private final boolean throwExceptionIfNoMarshallerFound;
    private final DefaultContentTypeProvider defaultContentTypeProvider;

    public static UnmarshalProcessor unmarshalProcessor(Unmarshallers unmarshallers, boolean throwExceptionIfNoMarshallerFound, DefaultContentTypeProvider defaultContentTypeProvider) {
        return new UnmarshalProcessor(unmarshallers, throwExceptionIfNoMarshallerFound, defaultContentTypeProvider);
    }

    @Override
    public void apply(MetaData metaData) {
        metaData.getOptional(HttpMaidChainKeys.REQUEST_BODY_STRING).ifPresent(body -> {
            Unmarshaller unmarshaller;
            ContentType contentType = metaData.get(HttpMaidChainKeys.REQUEST_CONTENT_TYPE);
            if (contentType.isEmpty()) {
                unmarshaller = this.defaultUnmarshaller(metaData);
            } else if (this.unmarshallersMap.supportsContentType(contentType)) {
                unmarshaller = this.unmarshallersMap.byContentType(contentType);
            } else if (!this.throwExceptionIfNoMarshallerFound) {
                unmarshaller = this.defaultUnmarshaller(metaData);
            } else {
                throw UnsupportedContentTypeException.unsupportedContentTypeException(contentType, this.unmarshallersMap.supportedContentTypes());
            }
            if (Objects.nonNull(unmarshaller)) {
                try {
                    Object unmarshalled = unmarshaller.unmarshall((String)body);
                    metaData.set(HttpMaidChainKeys.UNMARSHALLED_REQUEST_BODY, unmarshalled);
                }
                catch (Exception e) {
                    LOGGER.info("exception during marshalling", e);
                }
            }
        });
    }

    private Unmarshaller defaultUnmarshaller(MetaData metaData) {
        HttpRequest request = HttpRequest.httpRequest(metaData);
        ContentType defaultContentType = this.defaultContentTypeProvider.provideDefaultContentType(request);
        return this.unmarshallersMap.byContentType(defaultContentType);
    }

    @Generated
    public String toString() {
        return "UnmarshalProcessor(unmarshallersMap=" + this.unmarshallersMap + ", throwExceptionIfNoMarshallerFound=" + this.throwExceptionIfNoMarshallerFound + ", defaultContentTypeProvider=" + this.defaultContentTypeProvider + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnmarshalProcessor)) {
            return false;
        }
        UnmarshalProcessor other = (UnmarshalProcessor)o;
        Unmarshallers this$unmarshallersMap = this.unmarshallersMap;
        Unmarshallers other$unmarshallersMap = other.unmarshallersMap;
        if (this$unmarshallersMap == null ? other$unmarshallersMap != null : !((Object)this$unmarshallersMap).equals(other$unmarshallersMap)) {
            return false;
        }
        if (this.throwExceptionIfNoMarshallerFound != other.throwExceptionIfNoMarshallerFound) {
            return false;
        }
        DefaultContentTypeProvider this$defaultContentTypeProvider = this.defaultContentTypeProvider;
        DefaultContentTypeProvider other$defaultContentTypeProvider = other.defaultContentTypeProvider;
        return !(this$defaultContentTypeProvider == null ? other$defaultContentTypeProvider != null : !this$defaultContentTypeProvider.equals(other$defaultContentTypeProvider));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Unmarshallers $unmarshallersMap = this.unmarshallersMap;
        result = result * 59 + ($unmarshallersMap == null ? 43 : ((Object)$unmarshallersMap).hashCode());
        result = result * 59 + (this.throwExceptionIfNoMarshallerFound ? 79 : 97);
        DefaultContentTypeProvider $defaultContentTypeProvider = this.defaultContentTypeProvider;
        result = result * 59 + ($defaultContentTypeProvider == null ? 43 : $defaultContentTypeProvider.hashCode());
        return result;
    }

    @Generated
    private UnmarshalProcessor(Unmarshallers unmarshallersMap, boolean throwExceptionIfNoMarshallerFound, DefaultContentTypeProvider defaultContentTypeProvider) {
        this.unmarshallersMap = unmarshallersMap;
        this.throwExceptionIfNoMarshallerFound = throwExceptionIfNoMarshallerFound;
        this.defaultContentTypeProvider = defaultContentTypeProvider;
    }
}

