/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets.broadcast;

import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.MetaDataKey;
import de.quantummaid.httpmaid.marshalling.Marshaller;
import de.quantummaid.httpmaid.marshalling.Marshallers;
import de.quantummaid.httpmaid.serialization.Serializer;
import de.quantummaid.httpmaid.websockets.WebsocketMetaDataKeys;
import de.quantummaid.httpmaid.websockets.broadcast.BroadcasterFactory;
import de.quantummaid.httpmaid.websockets.broadcast.RegisteredBroadcasterFactory;
import de.quantummaid.httpmaid.websockets.broadcast.SerializingSender;
import de.quantummaid.httpmaid.websockets.disconnect.Disconnector;
import de.quantummaid.httpmaid.websockets.disconnect.DisconnectorFactory;
import de.quantummaid.httpmaid.websockets.registry.WebsocketRegistry;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSenders;
import de.quantummaid.reflectmaid.ResolvedType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public final class Broadcasters {
    public static final MetaDataKey<Broadcasters> BROADCASTERS = MetaDataKey.metaDataKey("BROADCASTERS");
    private final List<RegisteredBroadcasterFactory> broadcasterFactories = new ArrayList<RegisteredBroadcasterFactory>();
    private final Map<Class<?>, DisconnectorFactory<?>> disconnectorFactories = new LinkedHashMap();

    public static Broadcasters broadcasters() {
        return new Broadcasters();
    }

    public <T, U> void addBroadcaster(Class<T> type, Class<U> messageType, BroadcasterFactory<T, U> factory) {
        RegisteredBroadcasterFactory registeredFactory = RegisteredBroadcasterFactory.registeredBroadcasterFactory(factory, type, messageType);
        this.broadcasterFactories.add(registeredFactory);
    }

    public <T> void addDisconnector(Class<T> type, DisconnectorFactory<T> factory) {
        this.disconnectorFactories.put(type, factory);
    }

    public List<Class<?>> injectionTypes() {
        ArrayList injectionTypes = new ArrayList();
        this.broadcasterFactories.stream().map(RegisteredBroadcasterFactory::senderType).map(ResolvedType::assignableType).forEach(injectionTypes::add);
        injectionTypes.addAll(this.disconnectorFactories.keySet());
        return injectionTypes;
    }

    public List<Class<?>> messageTypes() {
        return this.broadcasterFactories.stream().map(RegisteredBroadcasterFactory::messageType).map(ResolvedType::assignableType).collect(Collectors.toList());
    }

    public List<Object> instantiateAll(MetaData metaData) {
        WebsocketSenders websocketSenders = metaData.get(WebsocketSenders.WEBSOCKET_SENDERS);
        WebsocketRegistry websocketRegistry = metaData.get(WebsocketMetaDataKeys.WEBSOCKET_REGISTRY);
        Serializer serializer = metaData.get(Serializer.SERIALIZER);
        ArrayList<Object> instances = new ArrayList<Object>();
        this.broadcasterFactories.stream().map(broadcasterFactory -> {
            Marshallers marshallers = metaData.get(Marshallers.MARSHALLERS);
            Marshaller marshaller = marshallers.determineResponseMarshaller(metaData);
            ResolvedType messageType = broadcasterFactory.messageType();
            SerializingSender serializingSender = SerializingSender.serializingSender(websocketRegistry, websocketSenders, messageType, marshaller, serializer);
            BroadcasterFactory<?, Object> factory = broadcasterFactory.factory();
            return factory.createBroadcaster(serializingSender);
        }).forEach(instances::add);
        Disconnector disconnector = Disconnector.disconnector(websocketRegistry, websocketSenders);
        this.disconnectorFactories.values().stream().map(disconnectorFactory -> disconnectorFactory.createDisconnector(disconnector)).forEach(instances::add);
        return instances;
    }

    @Generated
    public String toString() {
        return "Broadcasters(broadcasterFactories=" + this.broadcasterFactories + ", disconnectorFactories=" + this.disconnectorFactories + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Broadcasters)) {
            return false;
        }
        Broadcasters other = (Broadcasters)o;
        List<RegisteredBroadcasterFactory> this$broadcasterFactories = this.broadcasterFactories;
        List<RegisteredBroadcasterFactory> other$broadcasterFactories = other.broadcasterFactories;
        if (this$broadcasterFactories == null ? other$broadcasterFactories != null : !((Object)this$broadcasterFactories).equals(other$broadcasterFactories)) {
            return false;
        }
        Map<Class<?>, DisconnectorFactory<?>> this$disconnectorFactories = this.disconnectorFactories;
        Map<Class<?>, DisconnectorFactory<?>> other$disconnectorFactories = other.disconnectorFactories;
        return !(this$disconnectorFactories == null ? other$disconnectorFactories != null : !((Object)this$disconnectorFactories).equals(other$disconnectorFactories));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<RegisteredBroadcasterFactory> $broadcasterFactories = this.broadcasterFactories;
        result = result * 59 + ($broadcasterFactories == null ? 43 : ((Object)$broadcasterFactories).hashCode());
        Map<Class<?>, DisconnectorFactory<?>> $disconnectorFactories = this.disconnectorFactories;
        result = result * 59 + ($disconnectorFactories == null ? 43 : ((Object)$disconnectorFactories).hashCode());
        return result;
    }

    @Generated
    private Broadcasters() {
    }
}

