/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets.sender;

import de.quantummaid.httpmaid.websockets.sender.NonSerializableConnectionInformation;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSender;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSenderId;
import java.util.List;
import java.util.function.BiConsumer;
import lombok.Generated;

public final class NonSerializableWebsocketSender
implements WebsocketSender<NonSerializableConnectionInformation> {
    public static final WebsocketSenderId NON_SERIALIZABLE_WEBSOCKET_SENDER = WebsocketSenderId.websocketSenderId("NON_SERIALIZABLE_WEBSOCKET_SENDER");

    public static NonSerializableWebsocketSender nonSerializableWebsocketSender() {
        return new NonSerializableWebsocketSender();
    }

    @Override
    public void send(String message, List<NonSerializableConnectionInformation> connectionInformations, BiConsumer<NonSerializableConnectionInformation, Throwable> onException) {
        connectionInformations.forEach(connectionInformation -> {
            try {
                connectionInformation.send(message);
            }
            catch (Exception e) {
                onException.accept((NonSerializableConnectionInformation)connectionInformation, e);
            }
        });
    }

    @Override
    public void disconnect(List<NonSerializableConnectionInformation> connectionInformations, BiConsumer<NonSerializableConnectionInformation, Throwable> onException) {
        connectionInformations.forEach(connectionInformation -> {
            try {
                connectionInformation.disconnect();
            }
            catch (Exception e) {
                onException.accept((NonSerializableConnectionInformation)connectionInformation, e);
            }
        });
    }

    @Override
    public WebsocketSenderId senderId() {
        return NON_SERIALIZABLE_WEBSOCKET_SENDER;
    }

    @Generated
    public String toString() {
        return "NonSerializableWebsocketSender()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof NonSerializableWebsocketSender;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    private NonSerializableWebsocketSender() {
    }
}

