/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.injectmaid;

import de.quantummaid.injectmaid.Definition;
import de.quantummaid.injectmaid.Definitions;
import de.quantummaid.injectmaid.InjectMaid;
import de.quantummaid.injectmaid.InjectMaidModule;
import de.quantummaid.injectmaid.ReusePolicy;
import de.quantummaid.injectmaid.Scope;
import de.quantummaid.injectmaid.Scopes;
import de.quantummaid.injectmaid.SingletonType;
import de.quantummaid.injectmaid.builder.ConstantConfigurators;
import de.quantummaid.injectmaid.builder.CustomTypeConfigurators;
import de.quantummaid.injectmaid.builder.FactoryConfigurators;
import de.quantummaid.injectmaid.builder.ImplementationConfigurators;
import de.quantummaid.injectmaid.builder.ScopeConfigurators;
import de.quantummaid.injectmaid.builder.SingletonTypeConfigurator;
import de.quantummaid.injectmaid.builder.TypeConfigurators;
import de.quantummaid.injectmaid.customtype.CustomType;
import de.quantummaid.injectmaid.customtype.CustomTypeInstantiator;
import de.quantummaid.injectmaid.instantiator.BindInstantiator;
import de.quantummaid.injectmaid.instantiator.ConstantInstantiator;
import de.quantummaid.injectmaid.instantiator.Instantiator;
import de.quantummaid.injectmaid.instantiator.ScopeInstantiator;
import de.quantummaid.injectmaid.statemachine.Context;
import de.quantummaid.injectmaid.statemachine.States;
import de.quantummaid.injectmaid.statemachine.states.ResolvingDependencies;
import de.quantummaid.injectmaid.statemachine.states.State;
import de.quantummaid.injectmaid.statemachine.states.Unresolved;
import de.quantummaid.injectmaid.statemachine.states.UnresolvedFactory;
import de.quantummaid.reflectmaid.ResolvedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;

public final class InjectMaidBuilder
implements FactoryConfigurators,
ScopeConfigurators,
ImplementationConfigurators,
TypeConfigurators,
CustomTypeConfigurators,
ConstantConfigurators,
SingletonTypeConfigurator {
    private final States states;
    private final Scope scope;
    private final Scopes scopes;
    private SingletonType defaultSingletonType = SingletonType.LAZY;

    static InjectMaidBuilder injectionMaidBuilder() {
        States states = States.states();
        Scope scope = Scope.rootScope();
        Scopes scopes = Scopes.scopes();
        scopes.add(scope);
        return new InjectMaidBuilder(states, scope, scopes);
    }

    public InjectMaidBuilder withModule(InjectMaidModule module) {
        module.apply(this);
        return this;
    }

    @Override
    public InjectMaidBuilder withScope(ResolvedType scopeType, InjectMaidModule module) {
        this.scopes.validateElementNotUsedSomewhereElse(scopeType, this.scope);
        Scope subScope = this.scope.childScope(scopeType);
        InjectMaidBuilder scopedBuilder = new InjectMaidBuilder(this.states, subScope, this.scopes);
        if (!this.scopes.contains(subScope)) {
            ScopeInstantiator scopeInstantiator = ScopeInstantiator.scopeInstantiator(scopeType);
            scopedBuilder.withInstantiator(scopeType, scopeInstantiator, ReusePolicy.PROTOTYPE);
        }
        this.scopes.add(subScope);
        module.apply(scopedBuilder);
        return this;
    }

    @Override
    public InjectMaidBuilder withFactory(ResolvedType type, ResolvedType factory, ReusePolicy reusePolicy) {
        Context context = Context.context(type, this.scope, this.states, reusePolicy);
        UnresolvedFactory state = UnresolvedFactory.unresolvedFactory(context, factory);
        this.states.addOrFailIfAlreadyPresent(state);
        return this;
    }

    @Override
    public InjectMaidBuilder withImplementation(ResolvedType type, ResolvedType implementation, ReusePolicy reusePolicy) {
        Context context = Context.context(type, this.scope, this.states, reusePolicy);
        BindInstantiator instantiator = BindInstantiator.bindInstantiator(implementation);
        context.setInstantiator(instantiator);
        ResolvingDependencies state = ResolvingDependencies.resolvingDependencies(context);
        this.states.addOrFailIfAlreadyPresent(state);
        return this;
    }

    @Override
    public InjectMaidBuilder withType(ResolvedType resolvedType, ReusePolicy reusePolicy) {
        Context context = Context.context(resolvedType, this.scope, this.states, reusePolicy);
        State state = Unresolved.unresolved(context);
        this.states.addOrFailIfAlreadyPresent(state);
        return this;
    }

    @Override
    public InjectMaidBuilder withCustomType(CustomType customType, ReusePolicy reusePolicy) {
        ResolvedType type = customType.resolvedType();
        CustomTypeInstantiator instantiator = customType.instantiator();
        return this.withInstantiator(type, instantiator, reusePolicy);
    }

    @Override
    public InjectMaidBuilder withConstant(ResolvedType resolvedType, Object instance) {
        Context context = Context.context(resolvedType, this.scope, this.states, ReusePolicy.PROTOTYPE);
        ConstantInstantiator instantiator = ConstantInstantiator.constantInstantiator(instance);
        context.setInstantiator(instantiator);
        ResolvingDependencies state = ResolvingDependencies.resolvingDependencies(context);
        this.states.addOrFailIfAlreadyPresent(state);
        return this;
    }

    @Override
    public InjectMaidBuilder usingDefaultSingletonType(SingletonType singletonType) {
        this.defaultSingletonType = singletonType;
        return this;
    }

    public InjectMaidBuilder withInstantiator(ResolvedType resolvedType, Instantiator instantiator, ReusePolicy reusePolicy) {
        Context context = Context.context(resolvedType, this.scope, this.states, reusePolicy);
        context.setInstantiator(instantiator);
        ResolvingDependencies state = ResolvingDependencies.resolvingDependencies(context);
        this.states.addOrFailIfAlreadyPresent(state);
        return this;
    }

    public InjectMaid build() {
        while (!this.states.allFinal()) {
            this.states.update(State::detectInstantiator);
            this.states.update(State::resolvedDependencies);
        }
        HashMap<ResolvedType, List<Definition>> definitionsMap = new HashMap<ResolvedType, List<Definition>>();
        this.states.collect(State::context).map(context -> {
            ResolvedType type = context.type();
            Scope scopeOfType = context.scope();
            Instantiator instantiator = context.instantiator().orElseThrow();
            ReusePolicy reusePolicy = context.reusePolicy();
            return Definition.definition(type, scopeOfType, instantiator, reusePolicy);
        }).forEach(definition -> {
            ResolvedType type = definition.type();
            if (!definitionsMap.containsKey(type)) {
                definitionsMap.put(type, new ArrayList(1));
            }
            ((List)definitionsMap.get(type)).add(definition);
        });
        Definitions definitions = Definitions.definitions(this.scopes.asList(), definitionsMap);
        return InjectMaid.injectMaid(definitions, this.defaultSingletonType);
    }

    @Generated
    public String toString() {
        return "InjectMaidBuilder(states=" + this.states + ", scope=" + this.scope + ", scopes=" + this.scopes + ", defaultSingletonType=" + this.defaultSingletonType + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InjectMaidBuilder)) {
            return false;
        }
        InjectMaidBuilder other = (InjectMaidBuilder)o;
        States this$states = this.states;
        States other$states = other.states;
        if (this$states == null ? other$states != null : !((Object)this$states).equals(other$states)) {
            return false;
        }
        Scope this$scope = this.scope;
        Scope other$scope = other.scope;
        if (this$scope == null ? other$scope != null : !((Object)this$scope).equals(other$scope)) {
            return false;
        }
        Scopes this$scopes = this.scopes;
        Scopes other$scopes = other.scopes;
        if (this$scopes == null ? other$scopes != null : !((Object)this$scopes).equals(other$scopes)) {
            return false;
        }
        SingletonType this$defaultSingletonType = this.defaultSingletonType;
        SingletonType other$defaultSingletonType = other.defaultSingletonType;
        return !(this$defaultSingletonType == null ? other$defaultSingletonType != null : !((Object)((Object)this$defaultSingletonType)).equals((Object)other$defaultSingletonType));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        States $states = this.states;
        result = result * 59 + ($states == null ? 43 : ((Object)$states).hashCode());
        Scope $scope = this.scope;
        result = result * 59 + ($scope == null ? 43 : ((Object)$scope).hashCode());
        Scopes $scopes = this.scopes;
        result = result * 59 + ($scopes == null ? 43 : ((Object)$scopes).hashCode());
        SingletonType $defaultSingletonType = this.defaultSingletonType;
        result = result * 59 + ($defaultSingletonType == null ? 43 : ((Object)((Object)$defaultSingletonType)).hashCode());
        return result;
    }

    @Generated
    private InjectMaidBuilder(States states, Scope scope, Scopes scopes) {
        this.states = states;
        this.scope = scope;
        this.scopes = scopes;
    }
}

