/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.injectmaid.detection.disambiguators;

import de.quantummaid.injectmaid.detection.InstantiationOptions;
import de.quantummaid.injectmaid.detection.disambiguators.DisambiguationResult;
import de.quantummaid.injectmaid.detection.disambiguators.Disambiguator;
import de.quantummaid.injectmaid.instantiator.Instantiator;
import de.quantummaid.reflectmaid.ThirdPartyAnnotation;
import de.quantummaid.reflectmaid.resolver.ResolvedConstructor;
import de.quantummaid.reflectmaid.resolver.ResolvedMethod;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public final class AnnotationDisambiguator
implements Disambiguator {
    public static final ThirdPartyAnnotation INJECT = ThirdPartyAnnotation.thirdPartyAnnotation("javax.inject.Inject", "com.google.inject.Inject", "org.springframework.beans.factory.annotation.Autowired");

    public static AnnotationDisambiguator annotationDisambiguator() {
        return new AnnotationDisambiguator();
    }

    @Override
    public DisambiguationResult disambiguate(InstantiationOptions instantiationOptions) {
        List<Instantiator> annotatedInstantiators = AnnotationDisambiguator.annotatedWith(instantiationOptions, INJECT);
        if (annotatedInstantiators.size() == 1) {
            Instantiator instantiator = annotatedInstantiators.get(0);
            return DisambiguationResult.success(instantiator);
        }
        if (annotatedInstantiators.size() > 1) {
            String errorMessage = String.format("More than one constructor or factory method has been annotated for injection (considered are %s)", INJECT.describe());
            return DisambiguationResult.error(errorMessage);
        }
        return DisambiguationResult.ignore("No annotations have been detected");
    }

    private static List<Instantiator> annotatedWith(InstantiationOptions options, ThirdPartyAnnotation annotation) {
        ArrayList<Instantiator> annotatedInstantiators = new ArrayList<Instantiator>();
        options.constructors().stream().filter(constructorInstantiator -> {
            ResolvedConstructor constructor = constructorInstantiator.constructor();
            return annotation.isAnnotatedWith(constructor);
        }).forEach(annotatedInstantiators::add);
        options.staticFactoryMethods().stream().filter(factoryInstantiator -> {
            ResolvedMethod factory = factoryInstantiator.method();
            return annotation.isAnnotatedWith(factory);
        }).forEach(annotatedInstantiators::add);
        options.nonStaticFactoryMethods().stream().filter(factoryInstantiator -> {
            ResolvedMethod factory = factoryInstantiator.method();
            return annotation.isAnnotatedWith(factory);
        }).forEach(annotatedInstantiators::add);
        return annotatedInstantiators;
    }

    @Generated
    public String toString() {
        return "AnnotationDisambiguator()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof AnnotationDisambiguator;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    private AnnotationDisambiguator() {
    }
}

