/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.injectmaid.detection.disambiguators;

import de.quantummaid.injectmaid.instantiator.Instantiator;
import de.quantummaid.reflectmaid.validators.NotNullValidator;
import lombok.Generated;

public final class DisambiguationResult {
    private final String errorMessage;
    private final String ignoreMessage;
    private final Instantiator instantiator;

    public static DisambiguationResult error(String errorMessage) {
        NotNullValidator.validateNotNull(errorMessage, "errorMessage");
        return new DisambiguationResult(errorMessage, null, null);
    }

    public static DisambiguationResult ignore(String ignoreMessage) {
        NotNullValidator.validateNotNull(ignoreMessage, "ignoreMessage");
        return new DisambiguationResult(null, ignoreMessage, null);
    }

    public static DisambiguationResult success(Instantiator instantiator) {
        NotNullValidator.validateNotNull(instantiator, "instantiator");
        return new DisambiguationResult(null, null, instantiator);
    }

    public boolean isError() {
        return this.errorMessage != null;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public boolean isIgnore() {
        return this.ignoreMessage != null;
    }

    public String ignoreMessage() {
        return this.ignoreMessage;
    }

    public boolean isSuccess() {
        return this.instantiator != null;
    }

    public Instantiator instantiator() {
        return this.instantiator;
    }

    @Generated
    public String toString() {
        return "DisambiguationResult(errorMessage=" + this.errorMessage + ", ignoreMessage=" + this.ignoreMessage + ", instantiator=" + this.instantiator + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DisambiguationResult)) {
            return false;
        }
        DisambiguationResult other = (DisambiguationResult)o;
        String this$errorMessage = this.errorMessage;
        String other$errorMessage = other.errorMessage;
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) {
            return false;
        }
        String this$ignoreMessage = this.ignoreMessage;
        String other$ignoreMessage = other.ignoreMessage;
        if (this$ignoreMessage == null ? other$ignoreMessage != null : !this$ignoreMessage.equals(other$ignoreMessage)) {
            return false;
        }
        Instantiator this$instantiator = this.instantiator;
        Instantiator other$instantiator = other.instantiator;
        return !(this$instantiator == null ? other$instantiator != null : !this$instantiator.equals(other$instantiator));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $errorMessage = this.errorMessage;
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        String $ignoreMessage = this.ignoreMessage;
        result = result * 59 + ($ignoreMessage == null ? 43 : $ignoreMessage.hashCode());
        Instantiator $instantiator = this.instantiator;
        result = result * 59 + ($instantiator == null ? 43 : $instantiator.hashCode());
        return result;
    }

    @Generated
    private DisambiguationResult(String errorMessage, String ignoreMessage, Instantiator instantiator) {
        this.errorMessage = errorMessage;
        this.ignoreMessage = ignoreMessage;
        this.instantiator = instantiator;
    }
}

