/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder;

import de.quantummaid.mapmaid.MapMaid;
import de.quantummaid.mapmaid.builder.AdvancedBuilder;
import de.quantummaid.mapmaid.builder.ManuallyAddedState;
import de.quantummaid.mapmaid.builder.MapMaidConfiguration;
import de.quantummaid.mapmaid.builder.RequiredCapabilities;
import de.quantummaid.mapmaid.builder.builder.CustomTypesBuilder;
import de.quantummaid.mapmaid.builder.builder.DetectedTypesBuilder;
import de.quantummaid.mapmaid.builder.builder.InjectingBuilder;
import de.quantummaid.mapmaid.builder.builder.ProgrammaticTypeBuilder;
import de.quantummaid.mapmaid.builder.conventional.ConventionalDefinitionFactories;
import de.quantummaid.mapmaid.builder.conventional.ConventionalDetectors;
import de.quantummaid.mapmaid.builder.customtypes.CustomType;
import de.quantummaid.mapmaid.builder.detection.SimpleDetector;
import de.quantummaid.mapmaid.builder.injection.InjectionSerializer;
import de.quantummaid.mapmaid.builder.recipes.Recipe;
import de.quantummaid.mapmaid.builder.resolving.Context;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.Disambiguators;
import de.quantummaid.mapmaid.builder.resolving.processing.CollectionResult;
import de.quantummaid.mapmaid.builder.resolving.processing.Processor;
import de.quantummaid.mapmaid.builder.resolving.processing.signals.AddDeserializationSignal;
import de.quantummaid.mapmaid.builder.resolving.processing.signals.AddManualDeserializerSignal;
import de.quantummaid.mapmaid.builder.resolving.processing.signals.AddManualSerializerSignal;
import de.quantummaid.mapmaid.builder.resolving.processing.signals.AddSerializationSignal;
import de.quantummaid.mapmaid.builder.resolving.states.StatefulDefinition;
import de.quantummaid.mapmaid.builder.resolving.states.detected.Unreasoned;
import de.quantummaid.mapmaid.builder.resolving.states.injecting.InjectedDefinition;
import de.quantummaid.mapmaid.collections.BiMap;
import de.quantummaid.mapmaid.collections.Collection;
import de.quantummaid.mapmaid.debug.DebugInformation;
import de.quantummaid.mapmaid.debug.Reason;
import de.quantummaid.mapmaid.debug.ScanInformationBuilder;
import de.quantummaid.mapmaid.mapper.definitions.Definition;
import de.quantummaid.mapmaid.mapper.definitions.Definitions;
import de.quantummaid.mapmaid.mapper.deserialization.Deserializer;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.validation.AggregatedValidationException;
import de.quantummaid.mapmaid.mapper.deserialization.validation.ExceptionMappingList;
import de.quantummaid.mapmaid.mapper.deserialization.validation.ExceptionMappingWithPropertyPath;
import de.quantummaid.mapmaid.mapper.deserialization.validation.ValidationError;
import de.quantummaid.mapmaid.mapper.deserialization.validation.ValidationErrorsMapping;
import de.quantummaid.mapmaid.mapper.deserialization.validation.ValidationMappings;
import de.quantummaid.mapmaid.mapper.marshalling.Marshaller;
import de.quantummaid.mapmaid.mapper.marshalling.MarshallerRegistry;
import de.quantummaid.mapmaid.mapper.marshalling.Unmarshaller;
import de.quantummaid.mapmaid.mapper.serialization.Serializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.TypeSerializer;
import de.quantummaid.mapmaid.polymorphy.PolymorphicDeserializer;
import de.quantummaid.mapmaid.polymorphy.PolymorphicSerializer;
import de.quantummaid.mapmaid.polymorphy.PolymorphicUtils;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import de.quantummaid.reflectmaid.GenericType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;

public final class MapMaidBuilder
implements DetectedTypesBuilder,
InjectingBuilder,
ProgrammaticTypeBuilder,
CustomTypesBuilder {
    private final List<ManuallyAddedState> manuallyAddedStates = new ArrayList<ManuallyAddedState>();
    private final SimpleDetector detector = ConventionalDetectors.conventionalDetector();
    private final Processor processor = Processor.processor();
    private final AdvancedBuilder advancedBuilder = AdvancedBuilder.advancedBuilder();
    private final List<Recipe> recipes = Collection.smallList();
    private final ValidationMappings validationMappings = ValidationMappings.empty();
    private final ValidationErrorsMapping validationErrorsMapping = validationErrors -> {
        throw AggregatedValidationException.fromList(validationErrors);
    };

    public static MapMaidBuilder mapMaidBuilder() {
        return new MapMaidBuilder();
    }

    @SafeVarargs
    public final <T> MapMaidBuilder serializingSubtypes(Class<T> superType, Class<? extends T> ... subTypes) {
        GenericType<T> genericSuperType = GenericType.genericType(superType);
        GenericType[] genericSubTypes = (GenericType[])Arrays.stream(subTypes).map(GenericType::genericType).toArray(GenericType[]::new);
        return this.serializingSubtypes(genericSuperType, genericSubTypes);
    }

    @SafeVarargs
    public final <T> MapMaidBuilder serializingSubtypes(GenericType<T> superType, GenericType<? extends T> ... subTypes) {
        TypeIdentifier superTypeIdentifier = TypeIdentifier.typeIdentifierFor(superType);
        TypeIdentifier[] subTypeIdentifiers = (TypeIdentifier[])Arrays.stream(subTypes).map(TypeIdentifier::typeIdentifierFor).toArray(TypeIdentifier[]::new);
        return this.serializingSubtypes(superTypeIdentifier, subTypeIdentifiers);
    }

    public MapMaidBuilder serializingSubtypes(TypeIdentifier superType, TypeIdentifier ... subTypes) {
        return this.withSubtypes(RequiredCapabilities.serialization(), superType, Arrays.asList(subTypes));
    }

    @SafeVarargs
    public final <T> MapMaidBuilder deserializingSubtypes(Class<T> superType, Class<? extends T> ... subTypes) {
        GenericType<T> genericSuperType = GenericType.genericType(superType);
        GenericType[] genericSubTypes = (GenericType[])Arrays.stream(subTypes).map(GenericType::genericType).toArray(GenericType[]::new);
        return this.deserializingSubtypes(genericSuperType, genericSubTypes);
    }

    @SafeVarargs
    public final <T> MapMaidBuilder deserializingSubtypes(GenericType<T> superType, GenericType<? extends T> ... subTypes) {
        TypeIdentifier superTypeIdentifier = TypeIdentifier.typeIdentifierFor(superType);
        TypeIdentifier[] subTypeIdentifiers = (TypeIdentifier[])Arrays.stream(subTypes).map(TypeIdentifier::typeIdentifierFor).toArray(TypeIdentifier[]::new);
        return this.deserializingSubtypes(superTypeIdentifier, subTypeIdentifiers);
    }

    public MapMaidBuilder deserializingSubtypes(TypeIdentifier superType, TypeIdentifier ... subTypes) {
        return this.withSubtypes(RequiredCapabilities.deserialization(), superType, Arrays.asList(subTypes));
    }

    @SafeVarargs
    public final <T> MapMaidBuilder serializingAndDeserializingSubtypes(Class<T> superType, Class<? extends T> ... subTypes) {
        GenericType<T> genericSuperType = GenericType.genericType(superType);
        GenericType[] genericSubTypes = (GenericType[])Arrays.stream(subTypes).map(GenericType::genericType).toArray(GenericType[]::new);
        return this.serializingAndDeserializingSubtypes(genericSuperType, genericSubTypes);
    }

    @SafeVarargs
    public final <T> MapMaidBuilder serializingAndDeserializingSubtypes(GenericType<T> superType, GenericType<? extends T> ... subTypes) {
        TypeIdentifier superTypeIdentifier = TypeIdentifier.typeIdentifierFor(superType);
        TypeIdentifier[] subTypeIdentifiers = (TypeIdentifier[])Arrays.stream(subTypes).map(TypeIdentifier::typeIdentifierFor).toArray(TypeIdentifier[]::new);
        return this.serializingAndDeserializingSubtypes(superTypeIdentifier, subTypeIdentifiers);
    }

    public MapMaidBuilder serializingAndDeserializingSubtypes(TypeIdentifier superType, TypeIdentifier ... subTypes) {
        return this.withSubtypes(RequiredCapabilities.duplex(), superType, Arrays.asList(subTypes));
    }

    public MapMaidBuilder withSubtypes(RequiredCapabilities capabilities, TypeIdentifier superType, List<TypeIdentifier> subTypes) {
        this.manuallyAddedStates.add(configuration -> {
            BiMap<String, TypeIdentifier> nameToType = PolymorphicUtils.nameToIdentifier(subTypes, configuration);
            String typeIdentifierKey = configuration.getTypeIdentifierKey();
            Context context = Context.emptyContext(this.processor::dispatch, superType);
            StatefulDefinition statefulDefinition = Unreasoned.unreasoned(context);
            this.processor.addState(statefulDefinition);
            if (capabilities.hasSerialization()) {
                PolymorphicSerializer serializer = PolymorphicSerializer.polymorphicSerializer(superType, nameToType, typeIdentifierKey);
                this.processor.dispatch(AddManualSerializerSignal.addManualSerializer(superType, serializer));
                this.processor.dispatch(AddSerializationSignal.addSerialization(superType, Reason.manuallyAdded()));
            }
            if (capabilities.hasDeserialization()) {
                PolymorphicDeserializer deserializer = PolymorphicDeserializer.polymorphicDeserializer(superType, nameToType, typeIdentifierKey);
                this.processor.dispatch(AddManualDeserializerSignal.addManualDeserializer(superType, deserializer));
                this.processor.dispatch(AddDeserializationSignal.addDeserialization(superType, Reason.manuallyAdded()));
            }
        });
        return this;
    }

    @Override
    public MapMaidBuilder injecting(TypeIdentifier typeIdentifier, TypeDeserializer deserializer) {
        Context context = Context.emptyContext(this.processor::dispatch, typeIdentifier);
        InjectionSerializer serializer = InjectionSerializer.injectionSerializer(typeIdentifier);
        context.setSerializer(serializer);
        context.setDeserializer(deserializer);
        StatefulDefinition statefulDefinition = InjectedDefinition.injectedDefinition(context);
        this.processor.addState(statefulDefinition);
        this.processor.dispatch(AddSerializationSignal.addSerialization(typeIdentifier, Reason.manuallyAdded()));
        this.processor.dispatch(AddDeserializationSignal.addDeserialization(typeIdentifier, Reason.manuallyAdded()));
        return this;
    }

    @Override
    public MapMaidBuilder withType(GenericType<?> type, RequiredCapabilities capabilities) {
        return this.withType(type, capabilities, Reason.manuallyAdded());
    }

    @Override
    public MapMaidBuilder withType(GenericType<?> type, RequiredCapabilities capabilities, Reason reason) {
        NotNullValidator.validateNotNull(type, "type");
        NotNullValidator.validateNotNull(capabilities, "capabilities");
        NotNullValidator.validateNotNull(reason, "reason");
        this.manuallyAddedStates.add(configuration -> {
            TypeIdentifier typeIdentifier = TypeIdentifier.typeIdentifierFor(type);
            if (capabilities.hasSerialization()) {
                this.processor.dispatch(AddSerializationSignal.addSerialization(typeIdentifier, reason));
            }
            if (capabilities.hasDeserialization()) {
                this.processor.dispatch(AddDeserializationSignal.addDeserialization(typeIdentifier, reason));
            }
        });
        return this;
    }

    @Override
    public <T> MapMaidBuilder withCustomType(RequiredCapabilities capabilities, CustomType<T> customType) {
        NotNullValidator.validateNotNull(capabilities, "capabilities");
        NotNullValidator.validateNotNull(customType, "customType");
        this.manuallyAddedStates.add(configuration -> {
            TypeIdentifier typeIdentifier = customType.type();
            Context context = Context.emptyContext(this.processor::dispatch, typeIdentifier);
            StatefulDefinition statefulDefinition = Unreasoned.unreasoned(context);
            this.processor.addState(statefulDefinition);
            if (capabilities.hasSerialization()) {
                Optional<TypeSerializer> serializer = customType.serializer();
                if (serializer.isEmpty()) {
                    throw new IllegalArgumentException(String.format("serializer is missing for type '%s'", typeIdentifier.description()));
                }
                this.processor.dispatch(AddManualSerializerSignal.addManualSerializer(typeIdentifier, serializer.get()));
                this.processor.dispatch(AddSerializationSignal.addSerialization(typeIdentifier, Reason.manuallyAdded()));
            }
            if (capabilities.hasDeserialization()) {
                Optional<TypeDeserializer> deserializer = customType.deserializer();
                if (deserializer.isEmpty()) {
                    throw new IllegalArgumentException(String.format("deserializer is missing for type '%s'", typeIdentifier.description()));
                }
                this.processor.dispatch(AddManualDeserializerSignal.addManualDeserializer(typeIdentifier, deserializer.get()));
                this.processor.dispatch(AddDeserializationSignal.addDeserialization(typeIdentifier, Reason.manuallyAdded()));
            }
        });
        return this;
    }

    public MapMaidBuilder usingRecipe(Recipe recipe) {
        this.recipes.add(recipe);
        return this;
    }

    public <T extends Throwable> MapMaidBuilder withExceptionIndicatingValidationError(Class<T> exceptionIndicatingValidationError) {
        return this.withExceptionIndicatingValidationError(exceptionIndicatingValidationError, (exception, propertyPath) -> new ValidationError(exception.getMessage(), propertyPath));
    }

    public <T extends Throwable> MapMaidBuilder withExceptionIndicatingValidationError(Class<T> exceptionIndicatingValidationError, ExceptionMappingWithPropertyPath<T> exceptionMapping) {
        this.validationMappings.putOneToOne(exceptionIndicatingValidationError, exceptionMapping);
        return this;
    }

    public <T extends Throwable> MapMaidBuilder withExceptionIndicatingMultipleValidationErrors(Class<T> exceptionType, ExceptionMappingList<T> mapping) {
        NotNullValidator.validateNotNull(exceptionType, "exceptionType");
        NotNullValidator.validateNotNull(mapping, "mapping");
        this.validationMappings.putOneToMany(exceptionType, mapping);
        return this;
    }

    public MapMaidBuilder withAdvancedSettings(Consumer<AdvancedBuilder> configurator) {
        configurator.accept(this.advancedBuilder);
        return this;
    }

    public MapMaid build() {
        this.recipes.forEach(Recipe::init);
        this.recipes.forEach(recipe -> recipe.cook(this));
        MapMaidConfiguration mapMaidConfiguration = this.advancedBuilder.mapMaidConfiguration();
        this.manuallyAddedStates.forEach(manuallyAddedState -> manuallyAddedState.addState(mapMaidConfiguration));
        Disambiguators disambiguators = this.advancedBuilder.buildDisambiguators();
        Map<TypeIdentifier, CollectionResult> result = this.processor.collect(this.detector, disambiguators, mapMaidConfiguration);
        HashMap<TypeIdentifier, Definition> definitionsMap = new HashMap<TypeIdentifier, Definition>(result.size());
        HashMap<TypeIdentifier, ScanInformationBuilder> scanInformationMap = new HashMap<TypeIdentifier, ScanInformationBuilder>(result.size());
        result.forEach((type, collectionResult) -> {
            definitionsMap.put((TypeIdentifier)type, collectionResult.definition());
            scanInformationMap.put((TypeIdentifier)type, collectionResult.scanInformation());
        });
        DebugInformation debugInformation = DebugInformation.debugInformation(scanInformationMap);
        Definitions definitions = Definitions.definitions(definitionsMap, debugInformation);
        MarshallerRegistry<Marshaller> marshallerRegistry = this.advancedBuilder.buildMarshallerRegistry();
        Serializer serializer = Serializer.theSerializer(marshallerRegistry, definitions, ConventionalDefinitionFactories.CUSTOM_PRIMITIVE_MAPPINGS, debugInformation);
        MarshallerRegistry<Unmarshaller> unmarshallerRegistry = this.advancedBuilder.buildUnmarshallerRegistry();
        Deserializer deserializer = Deserializer.theDeserializer(unmarshallerRegistry, definitions, ConventionalDefinitionFactories.CUSTOM_PRIMITIVE_MAPPINGS, this.validationMappings, this.validationErrorsMapping, debugInformation);
        return MapMaid.mapMaid(serializer, deserializer, debugInformation);
    }

    @Generated
    public String toString() {
        return "MapMaidBuilder(manuallyAddedStates=" + this.manuallyAddedStates + ", detector=" + this.detector + ", processor=" + this.processor + ", advancedBuilder=" + this.advancedBuilder + ", recipes=" + this.recipes + ", validationMappings=" + this.validationMappings + ", validationErrorsMapping=" + this.validationErrorsMapping + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapMaidBuilder)) {
            return false;
        }
        MapMaidBuilder other = (MapMaidBuilder)o;
        List<ManuallyAddedState> this$manuallyAddedStates = this.manuallyAddedStates;
        List<ManuallyAddedState> other$manuallyAddedStates = other.manuallyAddedStates;
        if (this$manuallyAddedStates == null ? other$manuallyAddedStates != null : !((Object)this$manuallyAddedStates).equals(other$manuallyAddedStates)) {
            return false;
        }
        SimpleDetector this$detector = this.detector;
        SimpleDetector other$detector = other.detector;
        if (this$detector == null ? other$detector != null : !((Object)this$detector).equals(other$detector)) {
            return false;
        }
        Processor this$processor = this.processor;
        Processor other$processor = other.processor;
        if (this$processor == null ? other$processor != null : !((Object)this$processor).equals(other$processor)) {
            return false;
        }
        AdvancedBuilder this$advancedBuilder = this.advancedBuilder;
        AdvancedBuilder other$advancedBuilder = other.advancedBuilder;
        if (this$advancedBuilder == null ? other$advancedBuilder != null : !((Object)this$advancedBuilder).equals(other$advancedBuilder)) {
            return false;
        }
        List<Recipe> this$recipes = this.recipes;
        List<Recipe> other$recipes = other.recipes;
        if (this$recipes == null ? other$recipes != null : !((Object)this$recipes).equals(other$recipes)) {
            return false;
        }
        ValidationMappings this$validationMappings = this.validationMappings;
        ValidationMappings other$validationMappings = other.validationMappings;
        if (this$validationMappings == null ? other$validationMappings != null : !((Object)this$validationMappings).equals(other$validationMappings)) {
            return false;
        }
        ValidationErrorsMapping this$validationErrorsMapping = this.validationErrorsMapping;
        ValidationErrorsMapping other$validationErrorsMapping = other.validationErrorsMapping;
        return !(this$validationErrorsMapping == null ? other$validationErrorsMapping != null : !this$validationErrorsMapping.equals(other$validationErrorsMapping));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ManuallyAddedState> $manuallyAddedStates = this.manuallyAddedStates;
        result = result * 59 + ($manuallyAddedStates == null ? 43 : ((Object)$manuallyAddedStates).hashCode());
        SimpleDetector $detector = this.detector;
        result = result * 59 + ($detector == null ? 43 : ((Object)$detector).hashCode());
        Processor $processor = this.processor;
        result = result * 59 + ($processor == null ? 43 : ((Object)$processor).hashCode());
        AdvancedBuilder $advancedBuilder = this.advancedBuilder;
        result = result * 59 + ($advancedBuilder == null ? 43 : ((Object)$advancedBuilder).hashCode());
        List<Recipe> $recipes = this.recipes;
        result = result * 59 + ($recipes == null ? 43 : ((Object)$recipes).hashCode());
        ValidationMappings $validationMappings = this.validationMappings;
        result = result * 59 + ($validationMappings == null ? 43 : ((Object)$validationMappings).hashCode());
        ValidationErrorsMapping $validationErrorsMapping = this.validationErrorsMapping;
        result = result * 59 + ($validationErrorsMapping == null ? 43 : $validationErrorsMapping.hashCode());
        return result;
    }

    @Generated
    private MapMaidBuilder() {
    }
}

