/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.conventional;

import de.quantummaid.mapmaid.builder.conventional.ConventionalDefinitionFactories;
import de.quantummaid.mapmaid.builder.detection.SimpleDetector;
import de.quantummaid.mapmaid.builder.detection.customprimitive.deserialization.ConstructorBasedCustomPrimitiveDeserializationDetector;
import de.quantummaid.mapmaid.builder.detection.customprimitive.deserialization.CustomPrimitiveDeserializationDetector;
import de.quantummaid.mapmaid.builder.detection.customprimitive.deserialization.EnumCustomPrimitiveDeserializationDetector;
import de.quantummaid.mapmaid.builder.detection.customprimitive.deserialization.StaticMethodBasedCustomPrimitiveDeserializationDetector;
import de.quantummaid.mapmaid.builder.detection.customprimitive.serialization.CustomPrimitiveSerializationDetector;
import de.quantummaid.mapmaid.builder.detection.customprimitive.serialization.EnumSerializationDetector;
import de.quantummaid.mapmaid.builder.detection.customprimitive.serialization.MethodBasedCustomPrimitiveSerializationDetector;
import de.quantummaid.mapmaid.builder.detection.serializedobject.deserialization.SerializedObjectDeserializationDetector;
import de.quantummaid.mapmaid.builder.detection.serializedobject.fields.FieldDetector;
import de.quantummaid.mapmaid.collections.Collection;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import java.util.List;
import lombok.Generated;

public final class DetectorBuilder {
    private final List<FieldDetector> fieldDetectors;
    private final List<SerializedObjectDeserializationDetector> serializedObjectDeserializationDetectors;
    private final List<CustomPrimitiveSerializationDetector> customPrimitiveSerializationDetectors;
    private final List<CustomPrimitiveDeserializationDetector> customPrimitiveDeserializationDetectors;

    public static DetectorBuilder detectorBuilder() {
        return new DetectorBuilder(Collection.smallList(), Collection.smallList(), Collection.smallList(), Collection.smallList());
    }

    public DetectorBuilder withFieldDetector(FieldDetector fieldDetector) {
        NotNullValidator.validateNotNull(fieldDetector, "fieldDetector");
        this.fieldDetectors.add(fieldDetector);
        return this;
    }

    public DetectorBuilder withSerializedObjectDeserializer(SerializedObjectDeserializationDetector detector) {
        NotNullValidator.validateNotNull(detector, "detector");
        this.serializedObjectDeserializationDetectors.add(detector);
        return this;
    }

    public DetectorBuilder withFactoryAndConstructorBasedCustomPrimitiveFactory() {
        this.customPrimitiveSerializationDetectors.add(EnumSerializationDetector.enumBased());
        this.customPrimitiveSerializationDetectors.add(MethodBasedCustomPrimitiveSerializationDetector.methodBased(ConventionalDefinitionFactories.CUSTOM_PRIMITIVE_MAPPINGS));
        this.customPrimitiveDeserializationDetectors.add(EnumCustomPrimitiveDeserializationDetector.enumDeserialization());
        this.customPrimitiveDeserializationDetectors.add(StaticMethodBasedCustomPrimitiveDeserializationDetector.staticMethodBased(ConventionalDefinitionFactories.CUSTOM_PRIMITIVE_MAPPINGS));
        this.customPrimitiveDeserializationDetectors.add(ConstructorBasedCustomPrimitiveDeserializationDetector.constructorBased(ConventionalDefinitionFactories.CUSTOM_PRIMITIVE_MAPPINGS));
        return this;
    }

    public SimpleDetector build() {
        return SimpleDetector.detector(this.fieldDetectors, this.serializedObjectDeserializationDetectors, this.customPrimitiveSerializationDetectors, this.customPrimitiveDeserializationDetectors);
    }

    @Generated
    public String toString() {
        return "DetectorBuilder(fieldDetectors=" + this.fieldDetectors + ", serializedObjectDeserializationDetectors=" + this.serializedObjectDeserializationDetectors + ", customPrimitiveSerializationDetectors=" + this.customPrimitiveSerializationDetectors + ", customPrimitiveDeserializationDetectors=" + this.customPrimitiveDeserializationDetectors + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DetectorBuilder)) {
            return false;
        }
        DetectorBuilder other = (DetectorBuilder)o;
        List<FieldDetector> this$fieldDetectors = this.fieldDetectors;
        List<FieldDetector> other$fieldDetectors = other.fieldDetectors;
        if (this$fieldDetectors == null ? other$fieldDetectors != null : !((Object)this$fieldDetectors).equals(other$fieldDetectors)) {
            return false;
        }
        List<SerializedObjectDeserializationDetector> this$serializedObjectDeserializationDetectors = this.serializedObjectDeserializationDetectors;
        List<SerializedObjectDeserializationDetector> other$serializedObjectDeserializationDetectors = other.serializedObjectDeserializationDetectors;
        if (this$serializedObjectDeserializationDetectors == null ? other$serializedObjectDeserializationDetectors != null : !((Object)this$serializedObjectDeserializationDetectors).equals(other$serializedObjectDeserializationDetectors)) {
            return false;
        }
        List<CustomPrimitiveSerializationDetector> this$customPrimitiveSerializationDetectors = this.customPrimitiveSerializationDetectors;
        List<CustomPrimitiveSerializationDetector> other$customPrimitiveSerializationDetectors = other.customPrimitiveSerializationDetectors;
        if (this$customPrimitiveSerializationDetectors == null ? other$customPrimitiveSerializationDetectors != null : !((Object)this$customPrimitiveSerializationDetectors).equals(other$customPrimitiveSerializationDetectors)) {
            return false;
        }
        List<CustomPrimitiveDeserializationDetector> this$customPrimitiveDeserializationDetectors = this.customPrimitiveDeserializationDetectors;
        List<CustomPrimitiveDeserializationDetector> other$customPrimitiveDeserializationDetectors = other.customPrimitiveDeserializationDetectors;
        return !(this$customPrimitiveDeserializationDetectors == null ? other$customPrimitiveDeserializationDetectors != null : !((Object)this$customPrimitiveDeserializationDetectors).equals(other$customPrimitiveDeserializationDetectors));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<FieldDetector> $fieldDetectors = this.fieldDetectors;
        result = result * 59 + ($fieldDetectors == null ? 43 : ((Object)$fieldDetectors).hashCode());
        List<SerializedObjectDeserializationDetector> $serializedObjectDeserializationDetectors = this.serializedObjectDeserializationDetectors;
        result = result * 59 + ($serializedObjectDeserializationDetectors == null ? 43 : ((Object)$serializedObjectDeserializationDetectors).hashCode());
        List<CustomPrimitiveSerializationDetector> $customPrimitiveSerializationDetectors = this.customPrimitiveSerializationDetectors;
        result = result * 59 + ($customPrimitiveSerializationDetectors == null ? 43 : ((Object)$customPrimitiveSerializationDetectors).hashCode());
        List<CustomPrimitiveDeserializationDetector> $customPrimitiveDeserializationDetectors = this.customPrimitiveDeserializationDetectors;
        result = result * 59 + ($customPrimitiveDeserializationDetectors == null ? 43 : ((Object)$customPrimitiveDeserializationDetectors).hashCode());
        return result;
    }

    @Generated
    private DetectorBuilder(List<FieldDetector> fieldDetectors, List<SerializedObjectDeserializationDetector> serializedObjectDeserializationDetectors, List<CustomPrimitiveSerializationDetector> customPrimitiveSerializationDetectors, List<CustomPrimitiveDeserializationDetector> customPrimitiveDeserializationDetectors) {
        this.fieldDetectors = fieldDetectors;
        this.serializedObjectDeserializationDetectors = serializedObjectDeserializationDetectors;
        this.customPrimitiveSerializationDetectors = customPrimitiveSerializationDetectors;
        this.customPrimitiveDeserializationDetectors = customPrimitiveDeserializationDetectors;
    }
}

