/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.detection.serializedobject;

import de.quantummaid.mapmaid.builder.detection.DetectionResult;
import de.quantummaid.mapmaid.builder.detection.serializedobject.Mirror;
import de.quantummaid.mapmaid.builder.detection.serializedobject.SerializationFieldInstantiation;
import de.quantummaid.mapmaid.mapper.serialization.serializers.serializedobject.SerializationField;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import de.quantummaid.reflectmaid.ResolvedType;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;

public final class SerializationFieldOptions {
    private final Map<String, List<SerializationField>> options;

    public static SerializationFieldOptions serializationFieldOptions() {
        return new SerializationFieldOptions(de.quantummaid.mapmaid.collections.Collection.smallMap());
    }

    public List<SerializationField> allFields() {
        return this.options.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public SerializationFieldOptions filter(Predicate<SerializationField> filter) {
        HashMap<String, List<SerializationField>> filtered = new HashMap<String, List<SerializationField>>(this.options.size());
        this.options.forEach((name, serializationFields) -> {
            List filteredFields = serializationFields.stream().filter(filter).collect(Collectors.toList());
            if (!filteredFields.isEmpty()) {
                filtered.put((String)name, filteredFields);
            }
        });
        return new SerializationFieldOptions(filtered);
    }

    public boolean isEmpty() {
        return this.options.isEmpty();
    }

    public void add(SerializationField field) {
        NotNullValidator.validateNotNull(field, "field");
        String name = field.name();
        if (!this.options.containsKey(name)) {
            this.options.put(name, de.quantummaid.mapmaid.collections.Collection.smallList());
        }
        this.options.get(name).add(field);
    }

    public boolean contains(String name, ResolvedType type) {
        if (!this.options.containsKey(name)) {
            return false;
        }
        return this.options.get(name).stream().map(SerializationField::type).anyMatch(type::equals);
    }

    public DetectionResult<SerializationFieldInstantiation> instantiateAll() {
        return DetectionResult.success(SerializationFieldInstantiation.serializationFieldInstantiation(this.options));
    }

    public DetectionResult<SerializationFieldInstantiation> instantiate(Map<String, TypeIdentifier> fields) {
        HashMap<String, List<SerializationField>> instantiableFields = new HashMap<String, List<SerializationField>>(fields.size());
        List<String> problems = de.quantummaid.mapmaid.collections.Collection.smallList();
        for (Map.Entry<String, TypeIdentifier> entry : fields.entrySet()) {
            String name = entry.getKey();
            if (!this.options.containsKey(name)) {
                problems.add(String.format("No field under the name '%s'", name));
                continue;
            }
            List<SerializationField> fieldsByName = this.options.get(name);
            TypeIdentifier type = entry.getValue();
            List<SerializationField> mirroredFields = SerializationFieldOptions.mirroredFields(type, fieldsByName);
            if (mirroredFields.isEmpty()) {
                problems.add(String.format("No field under name '%s' of a type similar to '%s'", name, type.description()));
            }
            instantiableFields.put(name, mirroredFields);
        }
        if (!problems.isEmpty()) {
            return DetectionResult.failure(problems);
        }
        SerializationFieldInstantiation instantiation = SerializationFieldInstantiation.serializationFieldInstantiation(instantiableFields);
        return DetectionResult.success(instantiation);
    }

    private static List<SerializationField> mirroredFields(TypeIdentifier type, List<SerializationField> options) {
        NotNullValidator.validateNotNull(type, "type");
        NotNullValidator.validateNotNull(options, "options");
        return options.stream().filter((? super T field) -> Mirror.mirrors(field.type(), type)).collect(Collectors.toList());
    }

    @Generated
    public String toString() {
        return "SerializationFieldOptions(options=" + this.options + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SerializationFieldOptions)) {
            return false;
        }
        SerializationFieldOptions other = (SerializationFieldOptions)o;
        Map<String, List<SerializationField>> this$options = this.options;
        Map<String, List<SerializationField>> other$options = other.options;
        return !(this$options == null ? other$options != null : !((Object)this$options).equals(other$options));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, List<SerializationField>> $options = this.options;
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        return result;
    }

    @Generated
    private SerializationFieldOptions(Map<String, List<SerializationField>> options) {
        this.options = options;
    }
}

