/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.symmetry.serializedobject;

import de.quantummaid.mapmaid.builder.detection.DetectionResult;
import de.quantummaid.mapmaid.builder.detection.serializedobject.SerializationFieldInstantiation;
import de.quantummaid.mapmaid.builder.detection.serializedobject.SerializationFieldOptions;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.DisambiguationContext;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.symmetry.serializedobject.EquivalenceClass;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.symmetry.serializedobject.EquivalenceSignature;
import de.quantummaid.mapmaid.collections.Collection;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.serializedobjects.SerializedObjectDeserializer;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import lombok.Generated;

public final class SymmetryBuilder {
    private static final String SEPARATOR = "\n-------------\n";
    private final Map<EquivalenceSignature, EquivalenceClass> equivalenceClasses;

    public static SymmetryBuilder symmetryBuilder() {
        return new SymmetryBuilder(Collection.smallMap());
    }

    public void addDeserializer(TypeDeserializer deserializer, DisambiguationContext context) {
        if (!(deserializer instanceof SerializedObjectDeserializer)) {
            throw new UnsupportedOperationException("This should never happen. Only serialized object deserializers can be checked for symmetry, but got: " + deserializer);
        }
        SerializedObjectDeserializer serializedObjectDeserializer = (SerializedObjectDeserializer)deserializer;
        List<EquivalenceSignature> equivalenceSignatures = EquivalenceSignature.allOfDeserializer(serializedObjectDeserializer, context);
        equivalenceSignatures.forEach(equivalenceSignature -> {
            if (!this.equivalenceClasses.containsKey(equivalenceSignature)) {
                int size = equivalenceSignature.size();
                this.equivalenceClasses.put((EquivalenceSignature)equivalenceSignature, EquivalenceClass.equivalenceClass(size));
            }
            this.equivalenceClasses.get(equivalenceSignature).addDeserializer(deserializer);
        });
    }

    public void addSerializer(SerializationFieldOptions serializer) {
        NotNullValidator.validateNotNull(serializer, "serializer");
        this.equivalenceClasses.forEach((signature, equivalenceClass) -> signature.match(serializer).ifPresent(specializedSerializer -> this.equivalenceClasses.get(signature).setSerializationFields((SerializationFieldInstantiation)specializedSerializer)));
    }

    public DetectionResult<EquivalenceClass> determineGreatestCommonFields() {
        List sorted = this.equivalenceClasses.keySet().stream().sorted().collect(Collectors.toList());
        List supportedClasses = sorted.stream().map(this.equivalenceClasses::get).filter(EquivalenceClass::fullySupported).collect(Collectors.toList());
        if (supportedClasses.isEmpty()) {
            return DetectionResult.failure("no symmetric result");
        }
        int maxSize = supportedClasses.stream().mapToInt(EquivalenceClass::size).max().orElseThrow(() -> new UnsupportedOperationException("This should never happen"));
        List maxClasses = supportedClasses.stream().filter(equivalenceClass -> equivalenceClass.size() == maxSize).collect(Collectors.toList());
        if (maxClasses.size() != 1) {
            StringJoiner joiner = new StringJoiner(SEPARATOR, SEPARATOR, SEPARATOR);
            maxClasses.stream().map(EquivalenceClass::describe).forEach(joiner::add);
            String message = String.format("ambiguous options as serialized object:%n%s", joiner.toString());
            return DetectionResult.failure(message);
        }
        EquivalenceClass winner = (EquivalenceClass)maxClasses.get(0);
        return DetectionResult.success(winner);
    }

    @Generated
    public String toString() {
        return "SymmetryBuilder(equivalenceClasses=" + this.equivalenceClasses + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SymmetryBuilder)) {
            return false;
        }
        SymmetryBuilder other = (SymmetryBuilder)o;
        Map<EquivalenceSignature, EquivalenceClass> this$equivalenceClasses = this.equivalenceClasses;
        Map<EquivalenceSignature, EquivalenceClass> other$equivalenceClasses = other.equivalenceClasses;
        return !(this$equivalenceClasses == null ? other$equivalenceClasses != null : !((Object)this$equivalenceClasses).equals(other$equivalenceClasses));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<EquivalenceSignature, EquivalenceClass> $equivalenceClasses = this.equivalenceClasses;
        result = result * 59 + ($equivalenceClasses == null ? 43 : ((Object)$equivalenceClasses).hashCode());
        return result;
    }

    @Generated
    private SymmetryBuilder(Map<EquivalenceSignature, EquivalenceClass> equivalenceClasses) {
        this.equivalenceClasses = equivalenceClasses;
    }
}

