/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.resolving.processing.factories;

import de.quantummaid.mapmaid.builder.MapMaidConfiguration;
import de.quantummaid.mapmaid.builder.resolving.Context;
import de.quantummaid.mapmaid.builder.resolving.processing.factories.StateFactory;
import de.quantummaid.mapmaid.builder.resolving.processing.factories.StateFactoryResult;
import de.quantummaid.mapmaid.builder.resolving.processing.factories.UndetectedFactory;
import de.quantummaid.mapmaid.builder.resolving.processing.factories.collections.ArrayCollectionDefinitionFactory;
import de.quantummaid.mapmaid.builder.resolving.processing.factories.collections.NativeJavaCollectionDefinitionFactory;
import de.quantummaid.mapmaid.builder.resolving.processing.factories.kotlin.KotlinSealedClassFactory;
import de.quantummaid.mapmaid.builder.resolving.processing.factories.primitives.BuiltInPrimitivesFactory;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public final class StateFactories {
    private final List<StateFactory> stateFactories;

    public static StateFactories defaultStateFactories() {
        List<StateFactory> stateFactories = List.of(BuiltInPrimitivesFactory.builtInPrimitivesFactory(), ArrayCollectionDefinitionFactory.arrayFactory(), NativeJavaCollectionDefinitionFactory.nativeJavaCollectionsFactory(), KotlinSealedClassFactory.kotlinSealedClassFactory(), UndetectedFactory.undetectedFactory());
        return new StateFactories(stateFactories);
    }

    public StateFactoryResult createState(TypeIdentifier type, Context context, MapMaidConfiguration mapMaidConfiguration) {
        for (StateFactory stateFactory : this.stateFactories) {
            Optional<StateFactoryResult> statefulDefinition = stateFactory.create(type, context, mapMaidConfiguration);
            if (!statefulDefinition.isPresent()) continue;
            return statefulDefinition.get();
        }
        throw new UnsupportedOperationException("This should never happen");
    }

    @Generated
    public String toString() {
        return "StateFactories(stateFactories=" + this.stateFactories + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StateFactories)) {
            return false;
        }
        StateFactories other = (StateFactories)o;
        List<StateFactory> this$stateFactories = this.stateFactories;
        List<StateFactory> other$stateFactories = other.stateFactories;
        return !(this$stateFactories == null ? other$stateFactories != null : !((Object)this$stateFactories).equals(other$stateFactories));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<StateFactory> $stateFactories = this.stateFactories;
        result = result * 59 + ($stateFactories == null ? 43 : ((Object)$stateFactories).hashCode());
        return result;
    }

    @Generated
    private StateFactories(List<StateFactory> stateFactories) {
        this.stateFactories = stateFactories;
    }
}

