/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.resolving.requirements;

import de.quantummaid.mapmaid.builder.resolving.requirements.DetectionRequirements;
import de.quantummaid.mapmaid.debug.Reason;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.TypeSerializer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public final class DetectionRequirementReasons {
    public final List<Reason> serializationReasons;
    public final List<Reason> deserializationReasons;
    private final List<Reason> objectEnforcingReasons;
    private final List<Reason> inlinedPrimitiveReasons;
    private final TypeSerializer manuallyConfiguredSerializer;
    private final TypeDeserializer manuallyConfiguredDeserializer;

    public static DetectionRequirementReasons empty() {
        return new DetectionRequirementReasons(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, null);
    }

    public DetectionRequirementReasons setManuallyConfiguredSerializer(TypeSerializer manuallyConfiguredSerializer) {
        return new DetectionRequirementReasons(this.serializationReasons, this.deserializationReasons, this.objectEnforcingReasons, this.inlinedPrimitiveReasons, manuallyConfiguredSerializer, this.manuallyConfiguredDeserializer);
    }

    public DetectionRequirementReasons setManuallyConfiguredDeserializer(TypeDeserializer manuallyConfiguredDeserializer) {
        return new DetectionRequirementReasons(this.serializationReasons, this.deserializationReasons, this.objectEnforcingReasons, this.inlinedPrimitiveReasons, this.manuallyConfiguredSerializer, manuallyConfiguredDeserializer);
    }

    public DetectionRequirementReasons addSerialization(Reason reason) {
        ArrayList<Reason> newSerializationReasons = new ArrayList<Reason>(this.serializationReasons);
        newSerializationReasons.add(reason);
        return new DetectionRequirementReasons(newSerializationReasons, this.deserializationReasons, this.objectEnforcingReasons, this.inlinedPrimitiveReasons, this.manuallyConfiguredSerializer, this.manuallyConfiguredDeserializer);
    }

    public DetectionRequirementReasons removeSerialization(Reason reason) {
        ArrayList<Reason> newSerializationReasons = new ArrayList<Reason>(this.serializationReasons);
        newSerializationReasons.remove(reason);
        return new DetectionRequirementReasons(newSerializationReasons, this.deserializationReasons, this.objectEnforcingReasons, this.inlinedPrimitiveReasons, this.manuallyConfiguredSerializer, this.manuallyConfiguredDeserializer);
    }

    public DetectionRequirementReasons addDeserialization(Reason reason) {
        ArrayList<Reason> newDeserializationReasons = new ArrayList<Reason>(this.deserializationReasons);
        newDeserializationReasons.add(reason);
        return new DetectionRequirementReasons(this.serializationReasons, newDeserializationReasons, this.objectEnforcingReasons, this.inlinedPrimitiveReasons, this.manuallyConfiguredSerializer, this.manuallyConfiguredDeserializer);
    }

    public DetectionRequirementReasons removeDeserialization(Reason reason) {
        ArrayList<Reason> newDeserializationReasons = new ArrayList<Reason>(this.deserializationReasons);
        newDeserializationReasons.remove(reason);
        return new DetectionRequirementReasons(this.serializationReasons, newDeserializationReasons, this.objectEnforcingReasons, this.inlinedPrimitiveReasons, this.manuallyConfiguredSerializer, this.manuallyConfiguredDeserializer);
    }

    public DetectionRequirementReasons enforceObject(Reason reason) {
        ArrayList<Reason> newObjectEnforcingReasons = new ArrayList<Reason>(this.objectEnforcingReasons);
        newObjectEnforcingReasons.add(reason);
        return new DetectionRequirementReasons(this.serializationReasons, this.deserializationReasons, newObjectEnforcingReasons, this.inlinedPrimitiveReasons, this.manuallyConfiguredSerializer, this.manuallyConfiguredDeserializer);
    }

    public boolean hasChanged(DetectionRequirementReasons old) {
        DetectionRequirements oldDetectionRequirements;
        DetectionRequirements currentDetectionRequirements = this.detectionRequirements();
        return !currentDetectionRequirements.equals(oldDetectionRequirements = old.detectionRequirements());
    }

    public DetectionRequirements detectionRequirements() {
        return DetectionRequirements.detectionRequirements(!this.serializationReasons.isEmpty(), !this.deserializationReasons.isEmpty(), !this.objectEnforcingReasons.isEmpty(), !this.inlinedPrimitiveReasons.isEmpty(), this.manuallyConfiguredSerializer, this.manuallyConfiguredDeserializer);
    }

    @Generated
    public String toString() {
        return "DetectionRequirementReasons(serializationReasons=" + this.serializationReasons + ", deserializationReasons=" + this.deserializationReasons + ", objectEnforcingReasons=" + this.objectEnforcingReasons + ", inlinedPrimitiveReasons=" + this.inlinedPrimitiveReasons + ", manuallyConfiguredSerializer=" + this.manuallyConfiguredSerializer + ", manuallyConfiguredDeserializer=" + this.manuallyConfiguredDeserializer + ")";
    }

    @Generated
    private DetectionRequirementReasons(List<Reason> serializationReasons, List<Reason> deserializationReasons, List<Reason> objectEnforcingReasons, List<Reason> inlinedPrimitiveReasons, TypeSerializer manuallyConfiguredSerializer, TypeDeserializer manuallyConfiguredDeserializer) {
        this.serializationReasons = serializationReasons;
        this.deserializationReasons = deserializationReasons;
        this.objectEnforcingReasons = objectEnforcingReasons;
        this.inlinedPrimitiveReasons = inlinedPrimitiveReasons;
        this.manuallyConfiguredSerializer = manuallyConfiguredSerializer;
        this.manuallyConfiguredDeserializer = manuallyConfiguredDeserializer;
    }
}

