/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.resolving.states.detected;

import de.quantummaid.mapmaid.builder.resolving.Context;
import de.quantummaid.mapmaid.builder.resolving.Report;
import de.quantummaid.mapmaid.builder.resolving.processing.CollectionResult;
import de.quantummaid.mapmaid.builder.resolving.processing.signals.RemoveDeserializationSignal;
import de.quantummaid.mapmaid.builder.resolving.processing.signals.RemoveSerializationSignal;
import de.quantummaid.mapmaid.builder.resolving.requirements.DetectionRequirements;
import de.quantummaid.mapmaid.builder.resolving.requirements.RequirementsReducer;
import de.quantummaid.mapmaid.builder.resolving.states.StatefulDefinition;
import de.quantummaid.mapmaid.builder.resolving.states.detected.ToBeDetected;
import de.quantummaid.mapmaid.builder.resolving.states.detected.Unreasoned;
import de.quantummaid.mapmaid.debug.Reason;
import de.quantummaid.mapmaid.debug.ScanInformationBuilder;
import de.quantummaid.mapmaid.mapper.definitions.Definition;
import de.quantummaid.mapmaid.mapper.definitions.GeneralDefinition;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.TypeSerializer;
import java.util.Optional;
import lombok.Generated;

public final class Resolved
extends StatefulDefinition {
    private Resolved(Context context) {
        super(context);
    }

    public static StatefulDefinition resolved(Context context) {
        return new Resolved(context);
    }

    @Override
    public StatefulDefinition changeRequirements(RequirementsReducer reducer) {
        boolean changed = this.context.scanInformationBuilder().changeRequirements(reducer);
        if (changed) {
            Reason transitiveReason = Reason.becauseOf(this.context.type());
            this.context.dispatch(RemoveSerializationSignal.removeSerialization(transitiveReason));
            this.context.dispatch(RemoveDeserializationSignal.removeDeserialization(transitiveReason));
            boolean unreasoned = this.context.scanInformationBuilder().detectionRequirements().isUnreasoned();
            if (unreasoned) {
                return Unreasoned.unreasoned(this.context);
            }
            return ToBeDetected.toBeDetected(this.context);
        }
        return this;
    }

    @Override
    public Optional<Report> getDefinition() {
        TypeDeserializer deserializer;
        TypeSerializer serializer;
        ScanInformationBuilder scanInformationBuilder = this.context.scanInformationBuilder();
        DetectionRequirements requirements = scanInformationBuilder.detectionRequirements();
        if (requirements.serialization) {
            serializer = this.context.serializer().orElseThrow();
            scanInformationBuilder.setSerializer(serializer);
        } else {
            serializer = null;
        }
        if (requirements.deserialization) {
            deserializer = this.context.deserializer().orElseThrow();
            scanInformationBuilder.setDeserializer(deserializer);
        } else {
            deserializer = null;
        }
        Definition definition = GeneralDefinition.generalDefinition(this.context.type(), serializer, deserializer);
        return Optional.of(Report.success(CollectionResult.collectionResult(definition, scanInformationBuilder)));
    }

    @Generated
    public String toString() {
        return "Resolved()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Resolved)) {
            return false;
        }
        Resolved other = (Resolved)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Resolved;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

