/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.resolving.states.detected;

import de.quantummaid.mapmaid.builder.resolving.Context;
import de.quantummaid.mapmaid.builder.resolving.processing.signals.AddDeserializationSignal;
import de.quantummaid.mapmaid.builder.resolving.processing.signals.AddSerializationSignal;
import de.quantummaid.mapmaid.builder.resolving.processing.signals.EnforceObjectSignal;
import de.quantummaid.mapmaid.builder.resolving.requirements.DetectionRequirements;
import de.quantummaid.mapmaid.builder.resolving.requirements.RequirementsReducer;
import de.quantummaid.mapmaid.builder.resolving.states.StatefulDefinition;
import de.quantummaid.mapmaid.builder.resolving.states.detected.Resolved;
import de.quantummaid.mapmaid.builder.resolving.states.detected.ToBeDetected;
import de.quantummaid.mapmaid.debug.Reason;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.TypeSerializer;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import java.util.List;
import lombok.Generated;

public final class Resolving
extends StatefulDefinition {
    private Resolving(Context context) {
        super(context);
    }

    public static Resolving resolvingDuplex(Context context) {
        return new Resolving(context);
    }

    @Override
    public StatefulDefinition changeRequirements(RequirementsReducer reducer) {
        boolean changed = this.context.scanInformationBuilder().changeRequirements(reducer);
        if (changed) {
            return ToBeDetected.toBeDetected(this.context);
        }
        return this;
    }

    @Override
    public StatefulDefinition resolve() {
        List<TypeIdentifier> requiredTypes;
        DetectionRequirements detectionRequirements = this.context.scanInformationBuilder().detectionRequirements();
        Reason reason = Reason.becauseOf(this.context.type());
        if (detectionRequirements.serialization) {
            TypeSerializer serializer = this.context.serializer().orElseThrow();
            requiredTypes = serializer.requiredTypes();
            requiredTypes.forEach(type -> this.context.dispatch(AddSerializationSignal.addSerialization(type, reason)));
            if (serializer.forcesDependenciesToBeObjects()) {
                requiredTypes.forEach(type -> this.context.dispatch(EnforceObjectSignal.enforceObject(type, reason)));
            }
        }
        if (detectionRequirements.deserialization) {
            TypeDeserializer deserializer = this.context.deserializer().orElseThrow();
            requiredTypes = deserializer.requiredTypes();
            requiredTypes.forEach(type -> this.context.dispatch(AddDeserializationSignal.addDeserialization(type, reason)));
            if (deserializer.forcesDependenciesToBeObjects()) {
                requiredTypes.forEach(type -> this.context.dispatch(EnforceObjectSignal.enforceObject(type, reason)));
            }
        }
        return Resolved.resolved(this.context);
    }

    @Generated
    public String toString() {
        return "Resolving()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Resolving)) {
            return false;
        }
        Resolving other = (Resolving)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Resolving;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

