/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.debug.scaninformation;

import de.quantummaid.mapmaid.debug.Reason;
import de.quantummaid.mapmaid.debug.SubReasonProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public final class Reasons {
    private final List<Reason> deserializationReasons;
    private final List<Reason> serializationReasons;
    private final SubReasonProvider serializationSubReasonProvider;
    private final SubReasonProvider deserializationSubReasonProvider;

    public static Reasons reasons(List<Reason> deserializationReasons, List<Reason> serializationReasons, SubReasonProvider serializationSubReasonProvider, SubReasonProvider deserializationSubReasonProvider) {
        return new Reasons(deserializationReasons, serializationReasons, serializationSubReasonProvider, deserializationSubReasonProvider);
    }

    public String dumpSerializationReasons() {
        return this.serializationReasons.stream().map(reason -> reason.render(this.serializationSubReasonProvider)).flatMap(Collection::stream).map(reason -> String.format("\t- %s", reason)).collect(Collectors.joining("\n", "", "\n"));
    }

    public String dumpDerializationReasons() {
        return this.deserializationReasons.stream().map(reason -> reason.render(this.deserializationSubReasonProvider)).flatMap(Collection::stream).map(reason -> String.format("\t- %s", reason)).collect(Collectors.joining("\n", "", "\n"));
    }

    public boolean hasSerializationReasons() {
        return !this.serializationReasons.isEmpty();
    }

    public boolean hasDeserializationReasons() {
        return !this.deserializationReasons.isEmpty();
    }

    public List<Reason> serializationReasons() {
        return Collections.unmodifiableList(this.serializationReasons);
    }

    public List<Reason> deserializationReasons() {
        return Collections.unmodifiableList(this.deserializationReasons);
    }

    @Generated
    public String toString() {
        return "Reasons(deserializationReasons=" + this.deserializationReasons + ", serializationReasons=" + this.serializationReasons + ", serializationSubReasonProvider=" + this.serializationSubReasonProvider + ", deserializationSubReasonProvider=" + this.deserializationSubReasonProvider + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Reasons)) {
            return false;
        }
        Reasons other = (Reasons)o;
        List<Reason> this$deserializationReasons = this.deserializationReasons;
        List<Reason> other$deserializationReasons = other.deserializationReasons;
        if (this$deserializationReasons == null ? other$deserializationReasons != null : !((Object)this$deserializationReasons).equals(other$deserializationReasons)) {
            return false;
        }
        List<Reason> this$serializationReasons = this.serializationReasons;
        List<Reason> other$serializationReasons = other.serializationReasons;
        if (this$serializationReasons == null ? other$serializationReasons != null : !((Object)this$serializationReasons).equals(other$serializationReasons)) {
            return false;
        }
        SubReasonProvider this$serializationSubReasonProvider = this.serializationSubReasonProvider;
        SubReasonProvider other$serializationSubReasonProvider = other.serializationSubReasonProvider;
        if (this$serializationSubReasonProvider == null ? other$serializationSubReasonProvider != null : !this$serializationSubReasonProvider.equals(other$serializationSubReasonProvider)) {
            return false;
        }
        SubReasonProvider this$deserializationSubReasonProvider = this.deserializationSubReasonProvider;
        SubReasonProvider other$deserializationSubReasonProvider = other.deserializationSubReasonProvider;
        return !(this$deserializationSubReasonProvider == null ? other$deserializationSubReasonProvider != null : !this$deserializationSubReasonProvider.equals(other$deserializationSubReasonProvider));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Reason> $deserializationReasons = this.deserializationReasons;
        result = result * 59 + ($deserializationReasons == null ? 43 : ((Object)$deserializationReasons).hashCode());
        List<Reason> $serializationReasons = this.serializationReasons;
        result = result * 59 + ($serializationReasons == null ? 43 : ((Object)$serializationReasons).hashCode());
        SubReasonProvider $serializationSubReasonProvider = this.serializationSubReasonProvider;
        result = result * 59 + ($serializationSubReasonProvider == null ? 43 : $serializationSubReasonProvider.hashCode());
        SubReasonProvider $deserializationSubReasonProvider = this.deserializationSubReasonProvider;
        result = result * 59 + ($deserializationSubReasonProvider == null ? 43 : $deserializationSubReasonProvider.hashCode());
        return result;
    }

    @Generated
    private Reasons(List<Reason> deserializationReasons, List<Reason> serializationReasons, SubReasonProvider serializationSubReasonProvider, SubReasonProvider deserializationSubReasonProvider) {
        this.deserializationReasons = deserializationReasons;
        this.serializationReasons = serializationReasons;
        this.serializationSubReasonProvider = serializationSubReasonProvider;
        this.deserializationSubReasonProvider = deserializationSubReasonProvider;
    }
}

