/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.deserialization;

import de.quantummaid.mapmaid.debug.DebugInformation;
import de.quantummaid.mapmaid.debug.MapMaidException;
import de.quantummaid.mapmaid.debug.scaninformation.ScanInformation;
import de.quantummaid.mapmaid.mapper.definitions.Definition;
import de.quantummaid.mapmaid.mapper.definitions.Definitions;
import de.quantummaid.mapmaid.mapper.deserialization.DeserializerCallback;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.validation.ExceptionTracker;
import de.quantummaid.mapmaid.mapper.deserialization.validation.ValidationErrorsMapping;
import de.quantummaid.mapmaid.mapper.deserialization.validation.ValidationResult;
import de.quantummaid.mapmaid.mapper.injector.Injector;
import de.quantummaid.mapmaid.mapper.universal.Universal;
import de.quantummaid.mapmaid.mapper.universal.UniversalInjection;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.mapmaid.shared.mapping.CustomPrimitiveMappings;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import java.util.Optional;
import lombok.Generated;

final class InternalDeserializer
implements DeserializerCallback {
    private final Definitions definitions;
    private final CustomPrimitiveMappings customPrimitiveMappings;
    private final ValidationErrorsMapping onValidationErrors;

    static InternalDeserializer internalDeserializer(Definitions definitions, CustomPrimitiveMappings customPrimitiveMappings, ValidationErrorsMapping validationErrorsMapping) {
        NotNullValidator.validateNotNull(definitions, "definitions");
        NotNullValidator.validateNotNull(customPrimitiveMappings, "customPrimitiveMappings");
        NotNullValidator.validateNotNull(validationErrorsMapping, "validationErrorsMapping");
        return new InternalDeserializer(definitions, customPrimitiveMappings, validationErrorsMapping);
    }

    <T> T deserialize(Universal input, TypeIdentifier targetType, ExceptionTracker exceptionTracker, Injector injector, DebugInformation debugInformation) {
        Object result = this.deserializeRecursive(input, targetType, exceptionTracker, injector, debugInformation);
        ValidationResult validationResult = exceptionTracker.validationResult();
        if (validationResult.hasValidationErrors()) {
            this.onValidationErrors.map(validationResult.validationErrors());
        }
        return (T)result;
    }

    @Override
    public Object deserializeRecursive(Universal input, TypeIdentifier targetType, ExceptionTracker exceptionTracker, Injector injector, DebugInformation debugInformation) {
        Optional<Object> namedDirectInjection = injector.getDirectInjectionForPropertyPath(exceptionTracker.getPosition());
        if (namedDirectInjection.isPresent()) {
            return namedDirectInjection.get();
        }
        Optional<Object> typedDirectInjection = injector.getDirectInjectionForType(targetType);
        if (typedDirectInjection.isPresent()) {
            return typedDirectInjection.get();
        }
        if (input instanceof UniversalInjection) {
            ScanInformation scanInformation = debugInformation.scanInformationFor(targetType);
            throw MapMaidException.mapMaidException(String.format("Pre-deserialized objects are not supported in the input but found '%s'. Please use injections to add pre-deserialized objects.", input.toNativeJava()), scanInformation);
        }
        Definition definition = this.definitions.getDefinitionForType(targetType);
        TypeDeserializer deserializer = definition.deserializer().orElseThrow(() -> {
            ScanInformation scanInformation = debugInformation.scanInformationFor(targetType);
            return MapMaidException.mapMaidException(String.format("No deserializer configured for '%s'", definition.type().description()), scanInformation);
        });
        Universal resolved = injector.getUniversalInjectionFor(exceptionTracker.getPosition()).orElse(input);
        return deserializer.deserialize(resolved, exceptionTracker, injector, this, this.customPrimitiveMappings, targetType, debugInformation);
    }

    @Generated
    public String toString() {
        return "InternalDeserializer(definitions=" + this.definitions + ", customPrimitiveMappings=" + this.customPrimitiveMappings + ", onValidationErrors=" + this.onValidationErrors + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InternalDeserializer)) {
            return false;
        }
        InternalDeserializer other = (InternalDeserializer)o;
        Definitions this$definitions = this.definitions;
        Definitions other$definitions = other.definitions;
        if (this$definitions == null ? other$definitions != null : !((Object)this$definitions).equals(other$definitions)) {
            return false;
        }
        CustomPrimitiveMappings this$customPrimitiveMappings = this.customPrimitiveMappings;
        CustomPrimitiveMappings other$customPrimitiveMappings = other.customPrimitiveMappings;
        if (this$customPrimitiveMappings == null ? other$customPrimitiveMappings != null : !((Object)this$customPrimitiveMappings).equals(other$customPrimitiveMappings)) {
            return false;
        }
        ValidationErrorsMapping this$onValidationErrors = this.onValidationErrors;
        ValidationErrorsMapping other$onValidationErrors = other.onValidationErrors;
        return !(this$onValidationErrors == null ? other$onValidationErrors != null : !this$onValidationErrors.equals(other$onValidationErrors));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Definitions $definitions = this.definitions;
        result = result * 59 + ($definitions == null ? 43 : ((Object)$definitions).hashCode());
        CustomPrimitiveMappings $customPrimitiveMappings = this.customPrimitiveMappings;
        result = result * 59 + ($customPrimitiveMappings == null ? 43 : ((Object)$customPrimitiveMappings).hashCode());
        ValidationErrorsMapping $onValidationErrors = this.onValidationErrors;
        result = result * 59 + ($onValidationErrors == null ? 43 : $onValidationErrors.hashCode());
        return result;
    }

    @Generated
    private InternalDeserializer(Definitions definitions, CustomPrimitiveMappings customPrimitiveMappings, ValidationErrorsMapping onValidationErrors) {
        this.definitions = definitions;
        this.customPrimitiveMappings = customPrimitiveMappings;
        this.onValidationErrors = onValidationErrors;
    }
}

