/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.deserialization.deserializers.customprimitives;

import de.quantummaid.mapmaid.debug.MapMaidException;
import de.quantummaid.mapmaid.debug.scaninformation.ScanInformation;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.customprimitives.CustomPrimitiveDeserializer;
import de.quantummaid.reflectmaid.ResolvedType;
import de.quantummaid.reflectmaid.resolver.ResolvedConstructor;
import de.quantummaid.reflectmaid.resolver.ResolvedParameter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.List;
import lombok.Generated;

public final class CustomPrimitiveByConstructorDeserializer
implements CustomPrimitiveDeserializer {
    private final ResolvedType baseType;
    private final ResolvedConstructor constructor;

    public static TypeDeserializer createDeserializer(ResolvedType type, ResolvedConstructor constructor) {
        int modifiers = constructor.constructor().getModifiers();
        if (Modifier.isAbstract(modifiers)) {
            throw MapMaidException.mapMaidException(String.format("The deserialization constructor %s configured for the custom primitive of type %s must not be abstract", constructor, type.description()), new ScanInformation[0]);
        }
        List<ResolvedParameter> parameterTypes = constructor.parameters();
        if (parameterTypes.size() != 1) {
            throw MapMaidException.mapMaidException(String.format("The deserialization constructor %s configured for the custom primitive of type %s must only have one parameter", constructor, type.description()), new ScanInformation[0]);
        }
        if (constructor.constructor().getDeclaringClass() != type.assignableType()) {
            throw MapMaidException.mapMaidException(String.format("The deserialization constructor %s configured for the custom primitive of type %s must return the custom primitive", constructor, type.description()), new ScanInformation[0]);
        }
        ResolvedType baseType = parameterTypes.get(0).type();
        return new CustomPrimitiveByConstructorDeserializer(baseType, constructor);
    }

    @Override
    public Class<?> baseType() {
        return this.baseType.assignableType();
    }

    @Override
    public Object deserialize(Object value) throws Exception {
        try {
            return this.constructor.constructor().newInstance(value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw MapMaidException.mapMaidException(String.format("Unexpected error invoking deserialization constructor %s for serialized custom primitive %s", this.constructor, value), e, new ScanInformation[0]);
        }
        catch (InvocationTargetException e) {
            throw this.handleInvocationTargetException(e, (String)value);
        }
    }

    private Exception handleInvocationTargetException(InvocationTargetException e, String value) {
        Throwable targetException = e.getTargetException();
        if (targetException instanceof Exception) {
            return (Exception)targetException;
        }
        throw MapMaidException.mapMaidException(String.format("Unexpected error invoking deserialization constructor %s for serialized custom primitive %s", this.constructor, value), (Exception)e, new ScanInformation[0]);
    }

    @Override
    public String description() {
        return CustomPrimitiveDeserializer.createDescription(this, this.constructor.describe());
    }

    public ResolvedConstructor constructor() {
        return this.constructor;
    }

    @Generated
    public String toString() {
        return "CustomPrimitiveByConstructorDeserializer(baseType=" + this.baseType + ", constructor=" + this.constructor + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomPrimitiveByConstructorDeserializer)) {
            return false;
        }
        CustomPrimitiveByConstructorDeserializer other = (CustomPrimitiveByConstructorDeserializer)o;
        ResolvedType this$baseType = this.baseType;
        ResolvedType other$baseType = other.baseType;
        if (this$baseType == null ? other$baseType != null : !this$baseType.equals(other$baseType)) {
            return false;
        }
        ResolvedConstructor this$constructor = this.constructor;
        ResolvedConstructor other$constructor = other.constructor;
        return !(this$constructor == null ? other$constructor != null : !((Object)this$constructor).equals(other$constructor));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResolvedType $baseType = this.baseType;
        result = result * 59 + ($baseType == null ? 43 : $baseType.hashCode());
        ResolvedConstructor $constructor = this.constructor;
        result = result * 59 + ($constructor == null ? 43 : ((Object)$constructor).hashCode());
        return result;
    }

    @Generated
    private CustomPrimitiveByConstructorDeserializer(ResolvedType baseType, ResolvedConstructor constructor) {
        this.baseType = baseType;
        this.constructor = constructor;
    }
}

