/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.schema;

import de.quantummaid.mapmaid.collections.BiMap;
import de.quantummaid.mapmaid.mapper.schema.SchemaCallback;
import de.quantummaid.mapmaid.mapper.universal.Universal;
import de.quantummaid.mapmaid.mapper.universal.UniversalObject;
import de.quantummaid.mapmaid.mapper.universal.UniversalString;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SchemaSupport {
    private static final String PROPERTIES = "properties";

    private SchemaSupport() {
    }

    public static Map<String, Object> stringConstant(String value) {
        return Map.of("type", "string", "pattern", value);
    }

    public static Universal schemaForPolymorphicParent(BiMap<String, TypeIdentifier> nameToType, String typeField, SchemaCallback schemaCallback) {
        ArrayList schemas = new ArrayList(nameToType.size());
        nameToType.forEach((name, implementation) -> {
            UniversalObject rawImplementationSchema = (UniversalObject)schemaCallback.schema((TypeIdentifier)implementation);
            Map implementationSchemaMap = (Map)rawImplementationSchema.toNativeJava();
            Map<String, Object> updated = SchemaSupport.addProperty(typeField, SchemaSupport.stringConstant(name), implementationSchemaMap);
            schemas.add(updated);
        });
        return UniversalObject.universalObjectFromNativeMap(Map.of("oneOf", schemas));
    }

    private static Map<String, Object> addProperty(String key, Map<String, Object> childSchema, Map<String, Object> objectSchema) {
        LinkedHashMap<String, Map<String, Object>> properties = new LinkedHashMap<String, Map<String, Object>>((Map)objectSchema.get(PROPERTIES));
        properties.put(key, childSchema);
        LinkedHashMap<String, Object> copy = new LinkedHashMap<String, Object>(objectSchema);
        copy.put(PROPERTIES, properties);
        return copy;
    }

    public static Universal schemaForObject(Map<String, TypeIdentifier> fields, SchemaCallback schemaCallback) {
        LinkedHashMap<String, Universal> properties = new LinkedHashMap<String, Universal>(fields.size());
        fields.forEach((key, typeIdentifier) -> {
            Universal childSchema = schemaCallback.schema((TypeIdentifier)typeIdentifier);
            properties.put((String)key, childSchema);
        });
        HashMap<String, Universal> map = new HashMap<String, Universal>();
        map.put("type", UniversalString.universalString("object"));
        map.put(PROPERTIES, UniversalObject.universalObject(properties));
        return UniversalObject.universalObject(map);
    }

    public static Universal schemaForCollection(TypeIdentifier contentType, SchemaCallback schemaCallback) {
        LinkedHashMap<String, Universal> map = new LinkedHashMap<String, Universal>();
        map.put("type", UniversalString.universalString("array"));
        Universal contentTypeSchema = schemaCallback.schema(contentType);
        map.put("items", contentTypeSchema);
        return UniversalObject.universalObject(map);
    }
}

