/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.serialization.serializers.serializedobject;

import de.quantummaid.mapmaid.debug.DebugInformation;
import de.quantummaid.mapmaid.mapper.schema.SchemaCallback;
import de.quantummaid.mapmaid.mapper.schema.SchemaSupport;
import de.quantummaid.mapmaid.mapper.serialization.SerializationCallback;
import de.quantummaid.mapmaid.mapper.serialization.serializers.TypeSerializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.serializedobject.SerializationField;
import de.quantummaid.mapmaid.mapper.serialization.serializers.serializedobject.SerializationFields;
import de.quantummaid.mapmaid.mapper.serialization.tracker.SerializationTracker;
import de.quantummaid.mapmaid.mapper.universal.Universal;
import de.quantummaid.mapmaid.mapper.universal.UniversalObject;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.mapmaid.shared.mapping.CustomPrimitiveMappings;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public final class SerializedObjectSerializer
implements TypeSerializer {
    private final SerializationFields fields;

    public static SerializedObjectSerializer serializedObjectSerializer(SerializationFields fields) {
        NotNullValidator.validateNotNull(fields, "fields");
        return new SerializedObjectSerializer(fields);
    }

    public SerializationFields fields() {
        return this.fields;
    }

    @Override
    public List<TypeIdentifier> requiredTypes() {
        return this.fields.typesList();
    }

    @Override
    public Universal serialize(Object object, SerializationCallback callback, SerializationTracker tracker, CustomPrimitiveMappings customPrimitiveMappings, DebugInformation debugInformation) {
        HashMap<String, Universal> map = new HashMap<String, Universal>(10);
        this.fields.fields().forEach(serializationField -> {
            TypeIdentifier type = serializationField.type();
            Object value = Optional.ofNullable(object).map(serializationField::query).orElse(null);
            Universal serializedValue = callback.serializeDefinition(type, value, tracker);
            String name = serializationField.name();
            map.put(name, serializedValue);
        });
        return UniversalObject.universalObject(map);
    }

    @Override
    public String description() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("as serialized object with fields:\n");
        stringBuilder.append(this.fields.describe());
        return stringBuilder.toString();
    }

    @Override
    public Universal schema(SchemaCallback schemaCallback) {
        Map<String, TypeIdentifier> fieldsMap = this.fields.fields().stream().collect(Collectors.toMap(SerializationField::name, SerializationField::type));
        return SchemaSupport.schemaForObject(fieldsMap, schemaCallback);
    }

    @Generated
    public String toString() {
        return "SerializedObjectSerializer(fields=" + this.fields + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SerializedObjectSerializer)) {
            return false;
        }
        SerializedObjectSerializer other = (SerializedObjectSerializer)o;
        SerializationFields this$fields = this.fields;
        SerializationFields other$fields = other.fields;
        return !(this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SerializationFields $fields = this.fields;
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        return result;
    }

    @Generated
    private SerializedObjectSerializer(SerializationFields fields) {
        this.fields = fields;
    }
}

