/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.minimaljson;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.eclipsesource.json.WriterConfig;
import de.quantummaid.mapmaid.mapper.marshalling.Marshaller;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;

public final class MinimalJsonMarshaller
implements Marshaller {
    public static MinimalJsonMarshaller minimalJsonMarshaller() {
        return new MinimalJsonMarshaller();
    }

    @Override
    public String marshal(Object object) {
        JsonValue jsonValue = this.marshallRec(object);
        return jsonValue.toString(WriterConfig.MINIMAL);
    }

    private JsonValue marshallRec(Object object) {
        if (object instanceof String) {
            return Json.value((String)object);
        }
        if (object instanceof Map) {
            JsonObject jsonObject = Json.object();
            Map inputMap = (Map)object;
            inputMap.forEach((k, v) -> {
                JsonValue jsonValue = this.marshallRec(v);
                jsonObject.add((String)k, jsonValue);
            });
            return jsonObject;
        }
        if (object instanceof List) {
            JsonArray arr = Json.array();
            List inputList = (List)object;
            inputList.stream().map(this::marshallRec).forEach(arr::add);
            return arr;
        }
        if (object instanceof Double) {
            return Json.value((Double)object);
        }
        if (object instanceof Long) {
            return Json.value((Long)object);
        }
        if (object instanceof Boolean) {
            return Json.value((Boolean)object);
        }
        if (Objects.isNull(object)) {
            return Json.value(null);
        }
        throw new IllegalArgumentException(String.format("unable to marshall object '%s' of type '%s' to json", object, object.getClass()));
    }

    @Generated
    public String toString() {
        return "MinimalJsonMarshaller()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof MinimalJsonMarshaller;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    private MinimalJsonMarshaller() {
    }
}

