/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.minimaljson;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.eclipsesource.json.WriterConfig;
import de.quantummaid.mapmaid.mapper.marshalling.Unmarshaller;
import java.math.BigDecimal;
import java.util.stream.Collectors;
import lombok.Generated;

public final class MinimalJsonUnmarshaller
implements Unmarshaller {
    public static MinimalJsonUnmarshaller minimalJsonUnmarshaller() {
        return new MinimalJsonUnmarshaller();
    }

    @Override
    public Object unmarshal(String input) {
        JsonValue json = Json.parse(input);
        return this.unmarshallRec(json);
    }

    private Object unmarshallRec(JsonValue json) {
        if (json.isString()) {
            return json.asString();
        }
        if (json.isObject()) {
            JsonObject members = json.asObject();
            return members.names().stream().collect(Collectors.toMap(name -> name, name -> {
                JsonValue jsonValue = members.get((String)name);
                return this.unmarshallRec(jsonValue);
            }));
        }
        if (json.isArray()) {
            return json.asArray().values().stream().map(this::unmarshallRec).collect(Collectors.toList());
        }
        if (json.isNumber()) {
            return this.unmarshalNumber(json);
        }
        if (json.isBoolean()) {
            return json.asBoolean();
        }
        if (json.isNull()) {
            return this.unmarshalNull();
        }
        throw new IllegalArgumentException("json value of an unknown type: " + json.toString(WriterConfig.PRETTY_PRINT));
    }

    private Object unmarshalNumber(JsonValue json) {
        BigDecimal number = new BigDecimal(json.toString());
        if (this.asIntegerValue(number)) {
            return number.longValue();
        }
        return number.doubleValue();
    }

    private Object unmarshalNull() {
        return null;
    }

    private boolean asIntegerValue(BigDecimal bd) {
        return bd.stripTrailingZeros().scale() <= 0;
    }

    @Generated
    public String toString() {
        return "MinimalJsonUnmarshaller()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof MinimalJsonUnmarshaller;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    private MinimalJsonUnmarshaller() {
    }
}

