/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.polymorphy;

import de.quantummaid.mapmaid.collections.BiMap;
import de.quantummaid.mapmaid.debug.DebugInformation;
import de.quantummaid.mapmaid.mapper.deserialization.DeserializerCallback;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.validation.ExceptionTracker;
import de.quantummaid.mapmaid.mapper.injector.Injector;
import de.quantummaid.mapmaid.mapper.schema.SchemaCallback;
import de.quantummaid.mapmaid.mapper.schema.SchemaSupport;
import de.quantummaid.mapmaid.mapper.universal.Universal;
import de.quantummaid.mapmaid.mapper.universal.UniversalObject;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.mapmaid.shared.mapping.CustomPrimitiveMappings;
import java.util.List;
import lombok.Generated;

public final class PolymorphicDeserializer
implements TypeDeserializer {
    private final TypeIdentifier typeIdentifier;
    private final BiMap<String, TypeIdentifier> nameToType;
    private final String typeField;

    public static PolymorphicDeserializer polymorphicDeserializer(TypeIdentifier typeIdentifier, BiMap<String, TypeIdentifier> nameToType, String typeField) {
        return new PolymorphicDeserializer(typeIdentifier, nameToType, typeField);
    }

    @Override
    public List<TypeIdentifier> requiredTypes() {
        return this.nameToType.values();
    }

    @Override
    public <T> T deserialize(Universal input, ExceptionTracker exceptionTracker, Injector injector, DeserializerCallback callback, CustomPrimitiveMappings customPrimitiveMappings, TypeIdentifier typeIdentifier, DebugInformation debugInformation) {
        UniversalObject universalObject = (UniversalObject)input;
        Universal typeAsUniversal = universalObject.getField(this.typeField).orElseThrow(() -> new IllegalArgumentException(String.format("Missing '%s' information in universal object %s", this.typeField, input.toNativeJava())));
        String type = (String)typeAsUniversal.toNativeJava();
        TypeIdentifier implementation = this.nameToType.lookup(type).orElseThrow(() -> {
            String subtypeIdentifier = String.join((CharSequence)", ", this.nameToType.keys());
            return new IllegalArgumentException(String.format("Unknown type '%s' (needs to be a subtype of %s, known subtype identifiers: [%s])", type, typeIdentifier.description(), subtypeIdentifier));
        });
        return (T)callback.deserializeRecursive(input, implementation, exceptionTracker, injector, debugInformation);
    }

    @Override
    public boolean forcesDependenciesToBeObjects() {
        return true;
    }

    @Override
    public String description() {
        return String.format("polymorphic deserializer for %s", this.typeIdentifier.description());
    }

    @Override
    public Universal schema(SchemaCallback schemaCallback) {
        return SchemaSupport.schemaForPolymorphicParent(this.nameToType, this.typeField, schemaCallback);
    }

    @Generated
    private PolymorphicDeserializer(TypeIdentifier typeIdentifier, BiMap<String, TypeIdentifier> nameToType, String typeField) {
        this.typeIdentifier = typeIdentifier;
        this.nameToType = nameToType;
        this.typeField = typeField;
    }
}

