/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.quantummaid;

import de.quantummaid.httpmaid.HttpConfiguration;
import de.quantummaid.httpmaid.HttpMaid;
import de.quantummaid.httpmaid.HttpMaidBuilder;
import de.quantummaid.httpmaid.PerRouteConfigurator;
import de.quantummaid.httpmaid.chains.Configurator;
import de.quantummaid.httpmaid.generator.builder.ConditionStage;
import de.quantummaid.httpmaid.mapmaid.MapMaidModule;
import de.quantummaid.httpmaid.usecases.UseCasesModule;
import de.quantummaid.quantummaid.EndpointCreator;
import de.quantummaid.quantummaid.UniqueAccessManager;
import de.quantummaid.quantummaid.injectmaid.InjectMaidInstantiatorFactory;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QuantumMaid
implements HttpConfiguration<QuantumMaid>,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuantumMaid.class);
    private final HttpMaidBuilder httpMaidBuilder;
    private HttpMaid httpMaid;
    private final List<EndpointCreator> endpoints = new ArrayList<EndpointCreator>(1);
    private final List<String> endpointUrls = new ArrayList<String>(1);
    private final CountDownLatch terminationTrigger = new CountDownLatch(1);
    private final CountDownLatch termination = new CountDownLatch(1);
    private final Thread shutdownHook = new Thread(this::close);

    public static QuantumMaid quantumMaid() {
        UseCasesModule useCasesModule = UseCasesModule.useCasesModule();
        InjectMaidInstantiatorFactory instantiatorFactory = InjectMaidInstantiatorFactory.injectMaidInstantiatorFactory();
        useCasesModule.setUseCaseInstantiatorFactory(instantiatorFactory);
        MapMaidModule mapMaidModule = MapMaidModule.mapMaidModule();
        HttpMaidBuilder httpMaidBuilder = HttpMaid.anHttpMaid().configured(Configurator.toUseModules(useCasesModule, mapMaidModule)).disableAutodectectionOfModules();
        return new QuantumMaid(httpMaidBuilder);
    }

    @Override
    public ConditionStage<QuantumMaid> serving(Object handler, PerRouteConfigurator ... perRouteConfigurators) {
        return condition -> {
            this.httpMaidBuilder.serving(handler, perRouteConfigurators).when(condition);
            return this;
        };
    }

    @Override
    public QuantumMaid configured(Configurator configurator) {
        this.httpMaidBuilder.configured(configurator);
        return this;
    }

    @Deprecated(since="1.0.51", forRemoval=true)
    public QuantumMaid withHttpMaid(HttpMaid httpMaid) {
        UniqueAccessManager.claim(httpMaid);
        this.httpMaid = httpMaid;
        return this;
    }

    public QuantumMaid withLocalHostEndpointOnPort(int port) {
        this.endpoints.add(EndpointCreator.pureJavaEndpointCreator(port));
        this.endpointUrls.add(String.format("http://localhost:%d/", port));
        return this;
    }

    public void runAsynchronously() {
        CountDownLatch initialization = new CountDownLatch(1);
        Thread thread = new Thread(() -> this.run(initialization));
        thread.start();
        QuantumMaid.awaitCountDownLatch(initialization);
    }

    public void run() {
        this.run(new CountDownLatch(1));
    }

    private void run(CountDownLatch initialization) {
        try (HttpMaid managedHttpMaid = this.httpMaid();){
            Instant begin = Instant.now();
            this.endpoints.forEach(endpoint -> endpoint.createEndpoint(managedHttpMaid));
            Instant end = Instant.now();
            Duration endpointStartUpTime = Duration.between(begin, end);
            this.renderSplash(endpointStartUpTime);
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            initialization.countDown();
            QuantumMaid.awaitCountDownLatch(this.terminationTrigger);
        }
        this.termination.countDown();
    }

    public HttpMaid httpMaid() {
        if (this.httpMaid == null) {
            this.httpMaid = this.httpMaidBuilder.build();
        }
        return this.httpMaid;
    }

    @Override
    public void close() {
        this.terminationTrigger.countDown();
        QuantumMaid.awaitCountDownLatch(this.terminationTrigger);
        if (!Thread.currentThread().equals(this.shutdownHook)) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
    }

    private void renderSplash(Duration endpointStartupTime) {
        LOGGER.info("\n   ____                    _                   __  __       _     _ \n  / __ \\                  | |                 |  \\/  |     (_)   | |\n | |  | |_   _  __ _ _ __ | |_ _   _ _ __ ___ | \\  / | __ _ _  __| |\n | |  | | | | |/ _` | '_ \\| __| | | | '_ ` _ \\| |\\/| |/ _` | |/ _` |\n | |__| | |_| | (_| | | | | |_| |_| | | | | | | |  | | (_| | | (_| |\n  \\___\\_\\\\__,_|\\__,_|_| |_|\\__|\\__,_|_| |_| |_|_|  |_|\\__,_|_|\\__,_|\n");
        Duration httpMaidStartUpTime = this.httpMaid.getMetaDatum(HttpMaid.STARTUP_TIME);
        long httpMaidMilliseconds = TimeUnit.MILLISECONDS.convert(httpMaidStartUpTime);
        long endpointsMilliseconds = TimeUnit.MILLISECONDS.convert(endpointStartupTime);
        long combinedMilliseconds = httpMaidMilliseconds + endpointsMilliseconds;
        LOGGER.info("Startup took: {}ms ({}ms initialization, {}ms endpoint startup)", combinedMilliseconds, httpMaidMilliseconds, endpointsMilliseconds);
        this.endpointUrls.forEach(url -> LOGGER.info(String.format("Serving %s", url)));
        LOGGER.info("Ready.");
    }

    private static void awaitCountDownLatch(CountDownLatch countDownLatch) {
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Generated
    public String toString() {
        return "QuantumMaid(httpMaidBuilder=" + this.httpMaidBuilder + ", httpMaid=" + this.httpMaid + ", endpoints=" + this.endpoints + ", endpointUrls=" + this.endpointUrls + ", terminationTrigger=" + this.terminationTrigger + ", termination=" + this.termination + ", shutdownHook=" + this.shutdownHook + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QuantumMaid)) {
            return false;
        }
        QuantumMaid other = (QuantumMaid)o;
        HttpMaidBuilder this$httpMaidBuilder = this.httpMaidBuilder;
        HttpMaidBuilder other$httpMaidBuilder = other.httpMaidBuilder;
        if (this$httpMaidBuilder == null ? other$httpMaidBuilder != null : !((Object)this$httpMaidBuilder).equals(other$httpMaidBuilder)) {
            return false;
        }
        HttpMaid this$httpMaid = this.httpMaid;
        HttpMaid other$httpMaid = other.httpMaid;
        if (this$httpMaid == null ? other$httpMaid != null : !this$httpMaid.equals(other$httpMaid)) {
            return false;
        }
        List<EndpointCreator> this$endpoints = this.endpoints;
        List<EndpointCreator> other$endpoints = other.endpoints;
        if (this$endpoints == null ? other$endpoints != null : !((Object)this$endpoints).equals(other$endpoints)) {
            return false;
        }
        List<String> this$endpointUrls = this.endpointUrls;
        List<String> other$endpointUrls = other.endpointUrls;
        if (this$endpointUrls == null ? other$endpointUrls != null : !((Object)this$endpointUrls).equals(other$endpointUrls)) {
            return false;
        }
        CountDownLatch this$terminationTrigger = this.terminationTrigger;
        CountDownLatch other$terminationTrigger = other.terminationTrigger;
        if (this$terminationTrigger == null ? other$terminationTrigger != null : !this$terminationTrigger.equals(other$terminationTrigger)) {
            return false;
        }
        CountDownLatch this$termination = this.termination;
        CountDownLatch other$termination = other.termination;
        if (this$termination == null ? other$termination != null : !this$termination.equals(other$termination)) {
            return false;
        }
        Thread this$shutdownHook = this.shutdownHook;
        Thread other$shutdownHook = other.shutdownHook;
        return !(this$shutdownHook == null ? other$shutdownHook != null : !this$shutdownHook.equals(other$shutdownHook));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HttpMaidBuilder $httpMaidBuilder = this.httpMaidBuilder;
        result = result * 59 + ($httpMaidBuilder == null ? 43 : ((Object)$httpMaidBuilder).hashCode());
        HttpMaid $httpMaid = this.httpMaid;
        result = result * 59 + ($httpMaid == null ? 43 : $httpMaid.hashCode());
        List<EndpointCreator> $endpoints = this.endpoints;
        result = result * 59 + ($endpoints == null ? 43 : ((Object)$endpoints).hashCode());
        List<String> $endpointUrls = this.endpointUrls;
        result = result * 59 + ($endpointUrls == null ? 43 : ((Object)$endpointUrls).hashCode());
        CountDownLatch $terminationTrigger = this.terminationTrigger;
        result = result * 59 + ($terminationTrigger == null ? 43 : $terminationTrigger.hashCode());
        CountDownLatch $termination = this.termination;
        result = result * 59 + ($termination == null ? 43 : $termination.hashCode());
        Thread $shutdownHook = this.shutdownHook;
        result = result * 59 + ($shutdownHook == null ? 43 : $shutdownHook.hashCode());
        return result;
    }

    @Generated
    private QuantumMaid(HttpMaidBuilder httpMaidBuilder) {
        this.httpMaidBuilder = httpMaidBuilder;
    }
}

