/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.messagebus.internal.brokering;

import de.quantummaid.eventmaid.channel.Channel;
import de.quantummaid.eventmaid.channel.action.Subscription;
import de.quantummaid.eventmaid.messagebus.channelcreating.MessageBusChannelFactory;
import de.quantummaid.eventmaid.messagebus.exception.MessageBusExceptionHandler;
import de.quantummaid.eventmaid.messagebus.internal.brokering.MessageBusBrokerStrategy;
import de.quantummaid.eventmaid.processingcontext.EventType;
import de.quantummaid.eventmaid.processingcontext.ProcessingContext;
import de.quantummaid.eventmaid.subscribing.Subscriber;
import de.quantummaid.eventmaid.subscribing.SubscriptionId;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;

public final class MessageBusBrokerStrategyImpl
implements MessageBusBrokerStrategy {
    private final Map<EventType, Channel<Object>> channelMap = new ConcurrentHashMap<EventType, Channel<Object>>();
    private final Map<SubscriptionId, List<EventType>> subscriptionLookupMap = new ConcurrentHashMap<SubscriptionId, List<EventType>>();
    private final MessageBusChannelFactory channelFactory;
    private final MessageBusExceptionHandler messageBusExceptionHandler;

    public static MessageBusBrokerStrategyImpl messageBusBrokerStrategyImpl(MessageBusChannelFactory channelFactory, MessageBusExceptionHandler exceptionHandler) {
        return new MessageBusBrokerStrategyImpl(channelFactory, exceptionHandler);
    }

    @Override
    public Channel<Object> getDeliveringChannelFor(EventType eventType) {
        return this.getOrCreateChannel(eventType);
    }

    private Channel<Object> getOrCreateChannel(EventType eventType) {
        if (this.channelMap.containsKey(eventType)) {
            return this.channelMap.get(eventType);
        }
        Channel<Object> channel = this.channelFactory.createChannel(eventType, null, this.messageBusExceptionHandler);
        this.channelMap.put(eventType, channel);
        return channel;
    }

    @Override
    public void addSubscriber(EventType eventType, Subscriber<Object> subscriber) {
        Channel<Object> channel = this.getOrCreateChannel(eventType);
        Subscription<Object> subscription = this.getChannelSubscription(channel);
        subscription.addSubscriber(subscriber);
        this.storeSubscriptionForLookup(eventType, subscriber);
    }

    @Override
    public void addRawSubscriber(EventType eventType, Subscriber<ProcessingContext<Object>> subscriber) {
        Channel<Object> channel = this.getOrCreateChannel(eventType);
        Subscription<Object> subscription = this.getChannelSubscription(channel);
        subscription.addRawSubscriber(subscriber);
        this.storeSubscriptionForLookup(eventType, subscriber);
    }

    private Subscription<Object> getChannelSubscription(Channel<Object> channel) {
        return (Subscription)channel.getDefaultAction();
    }

    private void storeSubscriptionForLookup(EventType eventType, Subscriber<?> subscriber) {
        List<Object> eventTypes;
        SubscriptionId subscriptionId = subscriber.getSubscriptionId();
        if (this.subscriptionLookupMap.containsKey(subscriptionId)) {
            eventTypes = this.subscriptionLookupMap.get(subscriptionId);
        } else {
            eventTypes = new LinkedList();
            this.subscriptionLookupMap.put(subscriptionId, eventTypes);
        }
        eventTypes.add(eventType);
    }

    @Override
    public void removeSubscriber(SubscriptionId subscriptionId) {
        if (this.subscriptionLookupMap.containsKey(subscriptionId)) {
            List<EventType> eventTypes = this.subscriptionLookupMap.get(subscriptionId);
            eventTypes.stream().map(this.channelMap::get).map(this::getChannelSubscription).forEach(subscription -> subscription.removeSubscriber(subscriptionId));
        }
    }

    @Override
    public List<Subscriber<?>> getAllSubscribers() {
        return this.channelMap.values().stream().map(this::getChannelSubscription).flatMap(subscription -> subscription.getAllSubscribers().stream()).collect(Collectors.toList());
    }

    @Override
    public Map<EventType, List<Subscriber<?>>> getSubscribersPerType() {
        return this.channelMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.getChannelSubscription((Channel)e.getValue()).getAllSubscribers()));
    }

    @Generated
    private MessageBusBrokerStrategyImpl(MessageBusChannelFactory channelFactory, MessageBusExceptionHandler messageBusExceptionHandler) {
        this.channelFactory = channelFactory;
        this.messageBusExceptionHandler = messageBusExceptionHandler;
    }
}

