/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.chains.graph;

import de.quantummaid.httpmaid.util.Validators;
import lombok.Generated;

public final class Label {
    private static final String HTML_TEMPLATE = "<%s>";
    private static final String TEXT_TEMPLATE = "\"%s\"";
    private final String content;

    public static Label emptyLabel() {
        return Label.textLabel("");
    }

    public static Label htmlLabel(String html) {
        Validators.validateNotNull(html, "html");
        return new Label(String.format(HTML_TEMPLATE, html));
    }

    public static Label textLabel(String text) {
        Validators.validateNotNull(text, "test");
        return new Label(String.format(TEXT_TEMPLATE, text));
    }

    String plot() {
        return this.content;
    }

    @Generated
    public String toString() {
        return "Label(content=" + this.content + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Label)) {
            return false;
        }
        Label other = (Label)o;
        String this$content = this.content;
        String other$content = other.content;
        return !(this$content == null ? other$content != null : !this$content.equals(other$content));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $content = this.content;
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        return result;
    }

    @Generated
    private Label(String content) {
        this.content = content;
    }
}

