/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.http;

import de.quantummaid.httpmaid.http.HeaderName;
import de.quantummaid.httpmaid.http.HeaderValue;
import de.quantummaid.httpmaid.util.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public final class ResponseHeaders {
    private final Map<HeaderName, List<HeaderValue>> headers;

    public static ResponseHeaders emptyResponseHeaders() {
        return new ResponseHeaders(new LinkedHashMap<HeaderName, List<HeaderValue>>());
    }

    public Optional<String> getOptionalHeader(String key) {
        HeaderName headerName = HeaderName.headerName(key);
        return Maps.getOptionally(this.headers, headerName).flatMap(headerValues -> headerValues.stream().findFirst()).map(HeaderValue::stringValue);
    }

    public String getHeader(String key) {
        return this.getOptionalHeader(key).orElseThrow(() -> new IllegalArgumentException(String.format("No header with name %s", key)));
    }

    public Map<String, List<String>> asStringMap() {
        return Maps.transformMap(this.headers, HeaderName::stringValue, headerValues -> headerValues.stream().map(HeaderValue::stringValue).collect(Collectors.toList()));
    }

    public void addHeader(String name, String value) {
        HeaderName headerName = HeaderName.headerName(name);
        List headerValues = Optional.ofNullable(this.headers.get(headerName)).orElse(new ArrayList());
        HeaderValue headerValue = HeaderValue.headerValue(value);
        headerValues.add(headerValue);
        this.headers.put(headerName, headerValues);
    }

    public void setHeader(String name, String value) {
        HeaderName headerName = HeaderName.headerName(name);
        HeaderValue headerValue = HeaderValue.headerValue(value);
        this.headers.put(headerName, new ArrayList<HeaderValue>(List.of(headerValue)));
    }

    @Generated
    public String toString() {
        return "ResponseHeaders(headers=" + this.headers + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResponseHeaders)) {
            return false;
        }
        ResponseHeaders other = (ResponseHeaders)o;
        Map<HeaderName, List<HeaderValue>> this$headers = this.headers;
        Map<HeaderName, List<HeaderValue>> other$headers = other.headers;
        return !(this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<HeaderName, List<HeaderValue>> $headers = this.headers;
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        return result;
    }

    @Generated
    private ResponseHeaders(Map<HeaderName, List<HeaderValue>> headers) {
        this.headers = headers;
    }
}

