/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.http.headers.cookies;

import de.quantummaid.httpmaid.http.headers.cookies.CookieName;
import de.quantummaid.httpmaid.http.headers.cookies.CookieValue;
import de.quantummaid.httpmaid.http.headers.cookies.SameSitePolicy;
import de.quantummaid.httpmaid.util.Validators;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public final class CookieBuilder {
    private final DateTimeFormatter httpDateTimeFormatter = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss O").localizedBy(Locale.US);
    private final List<String> elements;

    public static CookieBuilder cookie(String name, String value) {
        CookieName cookieName = CookieName.cookieName(name);
        CookieValue cookieValue = CookieValue.cookieValue(value);
        String nameAndValue = String.format("%s=\"%s\"", cookieName.stringValue(), cookieValue.stringValue());
        LinkedList<String> elements = new LinkedList<String>();
        elements.add(nameAndValue);
        return new CookieBuilder(elements);
    }

    public CookieBuilder withAttribute(String directive) {
        Validators.validateNotNullNorEmpty(directive, "directive");
        this.elements.add(directive);
        return this;
    }

    public CookieBuilder withAttribute(String key, String value) {
        Validators.validateNotNullNorEmpty(key, "key");
        Validators.validateNotNullNorEmpty(value, "value");
        return this.withAttribute(String.format("%s=%s", key, value));
    }

    public CookieBuilder withExpiresDirective(String expiresDirective) {
        return this.withAttribute("Expires", expiresDirective);
    }

    public CookieBuilder withExpiration(Instant expiration) {
        Validators.validateNotNull(expiration, "expiration");
        ZonedDateTime zonedDateTime = expiration.atZone(ZoneId.of("GMT"));
        String formattedDate = this.httpDateTimeFormatter.format(zonedDateTime);
        return this.withExpiresDirective(formattedDate);
    }

    public CookieBuilder withMaxAgeDirective(String maxAgeDirective) {
        return this.withAttribute("Max-Age", maxAgeDirective);
    }

    public CookieBuilder withMaxAge(int time, TimeUnit unit) {
        Validators.validateNotNull((Object)unit, "unit");
        long maxAgeInSeconds = unit.toSeconds(time);
        return this.withMaxAgeDirective(String.valueOf(maxAgeInSeconds));
    }

    public CookieBuilder withSecureDirective() {
        return this.withAttribute("Secure");
    }

    public CookieBuilder thatIsOnlySentViaHttps() {
        return this.withSecureDirective();
    }

    public CookieBuilder withHttpOnlyDirective() {
        return this.withAttribute("HttpOnly");
    }

    public CookieBuilder thatIsNotAccessibleFromJavaScript() {
        return this.withHttpOnlyDirective();
    }

    public CookieBuilder withSameSiteDirective(String sameSiteDirective) {
        return this.withAttribute("SameSite", sameSiteDirective);
    }

    public CookieBuilder withSameSitePolicy(SameSitePolicy policy) {
        Validators.validateNotNull((Object)policy, "policy");
        return this.withSameSiteDirective(policy.stringValue());
    }

    public CookieBuilder withDomainDirective(String domainDirective) {
        return this.withAttribute("Domain", domainDirective);
    }

    public CookieBuilder exposedToAllSubdomainsOf(String ... domains) {
        return this.withDomainDirective(String.join((CharSequence)",", Arrays.asList(domains)));
    }

    public CookieBuilder withPathDirective(String pathDirective) {
        return this.withAttribute("Path", pathDirective);
    }

    public CookieBuilder exposedOnlyToSubpathsOf(String ... paths) {
        return this.withPathDirective(String.join((CharSequence)",", Arrays.asList(paths)));
    }

    public String build() {
        return String.join((CharSequence)"; ", this.elements);
    }

    @Generated
    public String toString() {
        return "CookieBuilder(httpDateTimeFormatter=" + this.httpDateTimeFormatter + ", elements=" + this.elements + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CookieBuilder)) {
            return false;
        }
        CookieBuilder other = (CookieBuilder)o;
        DateTimeFormatter this$httpDateTimeFormatter = this.httpDateTimeFormatter;
        DateTimeFormatter other$httpDateTimeFormatter = other.httpDateTimeFormatter;
        if (this$httpDateTimeFormatter == null ? other$httpDateTimeFormatter != null : !this$httpDateTimeFormatter.equals(other$httpDateTimeFormatter)) {
            return false;
        }
        List<String> this$elements = this.elements;
        List<String> other$elements = other.elements;
        return !(this$elements == null ? other$elements != null : !((Object)this$elements).equals(other$elements));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DateTimeFormatter $httpDateTimeFormatter = this.httpDateTimeFormatter;
        result = result * 59 + ($httpDateTimeFormatter == null ? 43 : $httpDateTimeFormatter.hashCode());
        List<String> $elements = this.elements;
        result = result * 59 + ($elements == null ? 43 : ((Object)$elements).hashCode());
        return result;
    }

    @Generated
    private CookieBuilder(List<String> elements) {
        this.elements = elements;
    }
}

