/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.mapmaid;

import de.quantummaid.httpmaid.CoreModule;
import de.quantummaid.httpmaid.chains.ChainExtender;
import de.quantummaid.httpmaid.chains.ChainModule;
import de.quantummaid.httpmaid.chains.DependencyRegistry;
import de.quantummaid.httpmaid.events.enriching.Injection;
import de.quantummaid.httpmaid.http.headers.ContentType;
import de.quantummaid.httpmaid.mapmaid.MapMaidConfigurators;
import de.quantummaid.httpmaid.mapmaid.MapMaidMarshallingMapper;
import de.quantummaid.httpmaid.mapmaid.MapMaidValidationExceptionMapper;
import de.quantummaid.httpmaid.mapmaid.advancedscanner.UseCaseClassScanner;
import de.quantummaid.httpmaid.mapmaid.advancedscanner.deserialization_wrappers.MethodParameterDeserializationWrapper;
import de.quantummaid.httpmaid.marshalling.MarshallingModule;
import de.quantummaid.httpmaid.serialization.Serializer;
import de.quantummaid.httpmaid.usecases.UseCasesModule;
import de.quantummaid.httpmaid.usecases.serializing.SerializationAndDeserializationProvider;
import de.quantummaid.httpmaid.usecases.serializing.UseCaseParamaterProvider;
import de.quantummaid.httpmaid.usecases.serializing.UseCaseSerializationAndDeserialization;
import de.quantummaid.mapmaid.MapMaid;
import de.quantummaid.mapmaid.builder.MapMaidBuilder;
import de.quantummaid.mapmaid.mapper.deserialization.validation.AggregatedValidationException;
import de.quantummaid.mapmaid.mapper.marshalling.MarshallingType;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.reflectmaid.GenericType;
import de.quantummaid.reflectmaid.ResolvedType;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapMaidModule
implements ChainModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MapMaidModule.class);
    private static final int DEFAULT_VALIDATION_ERROR_STATUS_CODE = 400;
    private final MapMaidMarshallingMapper mapMaidMarshallingMapper = MapMaidMarshallingMapper.mapMaidMarshallingMapper();
    private volatile boolean addAggregatedExceptionHandler = true;
    private volatile int validationErrorStatusCode = 400;

    public static MapMaidModule mapMaidModule() {
        return new MapMaidModule();
    }

    public void doNotAddAggregatedExceptionHandler() {
        this.addAggregatedExceptionHandler = false;
    }

    public void addRequestContentTypeToUnmarshallingTypeMapping(ContentType contentType, MarshallingType<String> marshallingType) {
        this.mapMaidMarshallingMapper.addRequestContentTypeToUnmarshallingTypeMapping(contentType, marshallingType);
    }

    public void addMarshallingTypeToResponseContentTypeMapping(ContentType contentType, MarshallingType<String> marshallingType) {
        this.mapMaidMarshallingMapper.addMarshallingTypeToResponseContentTypeMapping(contentType, marshallingType);
    }

    public void setValidationErrorStatusCode(int validationErrorStatusCode) {
        this.validationErrorStatusCode = validationErrorStatusCode;
    }

    @Override
    public List<ChainModule> supplyModulesIfNotAlreadyPresent() {
        return Collections.singletonList(MarshallingModule.emptyMarshallingModule());
    }

    @Override
    public void configure(DependencyRegistry dependencyRegistry) {
        UseCasesModule useCasesModule = dependencyRegistry.getDependency(UseCasesModule.class);
        SerializationAndDeserializationProvider serializationAndDeserializationProvider = (useCaseMethods, injectionTypes, messageTypes) -> {
            MapMaidBuilder mapMaidBuilder = MapMaid.aMapMaid();
            injectionTypes.forEach(mapMaidBuilder::injecting);
            messageTypes.forEach(mapMaidBuilder::serializing);
            Map<ResolvedType, MethodParameterDeserializationWrapper> deserializationWrappers = UseCaseClassScanner.addAllReferencedClassesIn(useCaseMethods, mapMaidBuilder);
            dependencyRegistry.getMetaData().getOptional(MapMaidConfigurators.RECIPES).ifPresent(recipes -> recipes.forEach(mapMaidBuilder::usingRecipe));
            MapMaid mapMaid = this.buildMapMaid(mapMaidBuilder);
            HashMap<ResolvedType, UseCaseParamaterProvider> parameterProviders = new HashMap<ResolvedType, UseCaseParamaterProvider>();
            deserializationWrappers.forEach((type, wrapper) -> parameterProviders.put((ResolvedType)type, event -> {
                Map<String, Object> map = event.asMap();
                List<Injection> injections = event.injections();
                List<Object> typeInjections = event.typeInjections();
                return wrapper.deserializeParameters(map, injections, typeInjections, mapMaid);
            }));
            MarshallingModule marshallingModule = dependencyRegistry.getDependency(MarshallingModule.class);
            this.mapMaidMarshallingMapper.mapMarshalling(mapMaid, marshallingModule);
            Serializer serializer = (returnValue, type) -> mapMaid.serializer().serializeToUniversalObject(returnValue, TypeIdentifier.typeIdentifierFor(GenericType.fromResolvedType(type)));
            return UseCaseSerializationAndDeserialization.useCaseSerializationAndDeserialization(parameterProviders, serializer);
        };
        useCasesModule.setSerializationAndDeserializationProvider(serializationAndDeserializationProvider);
        if (this.addAggregatedExceptionHandler) {
            this.addExceptionHandler(dependencyRegistry);
        }
    }

    private void addExceptionHandler(DependencyRegistry dependencyRegistry) {
        CoreModule coreModule = dependencyRegistry.getDependency(CoreModule.class);
        coreModule.addExceptionMapper(throwable -> throwable instanceof AggregatedValidationException, MapMaidValidationExceptionMapper.mapMaidValidationExceptionMapper(this.validationErrorStatusCode));
    }

    private MapMaid buildMapMaid(MapMaidBuilder builder) {
        long startTime = System.currentTimeMillis();
        MapMaid mapMaid = builder.build();
        long endTime = System.currentTimeMillis();
        long time = endTime - startTime;
        if (log.isInfoEnabled()) {
            log.info("construction of MapMaid took {}ms", (Object)time);
        }
        return mapMaid;
    }

    @Override
    public void register(ChainExtender extender) {
    }

    @Generated
    public String toString() {
        return "MapMaidModule(mapMaidMarshallingMapper=" + this.mapMaidMarshallingMapper + ", addAggregatedExceptionHandler=" + this.addAggregatedExceptionHandler + ", validationErrorStatusCode=" + this.validationErrorStatusCode + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapMaidModule)) {
            return false;
        }
        MapMaidModule other = (MapMaidModule)o;
        if (this.addAggregatedExceptionHandler != other.addAggregatedExceptionHandler) {
            return false;
        }
        if (this.validationErrorStatusCode != other.validationErrorStatusCode) {
            return false;
        }
        MapMaidMarshallingMapper this$mapMaidMarshallingMapper = this.mapMaidMarshallingMapper;
        MapMaidMarshallingMapper other$mapMaidMarshallingMapper = other.mapMaidMarshallingMapper;
        return !(this$mapMaidMarshallingMapper == null ? other$mapMaidMarshallingMapper != null : !((Object)this$mapMaidMarshallingMapper).equals(other$mapMaidMarshallingMapper));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.addAggregatedExceptionHandler ? 79 : 97);
        result = result * 59 + this.validationErrorStatusCode;
        MapMaidMarshallingMapper $mapMaidMarshallingMapper = this.mapMaidMarshallingMapper;
        result = result * 59 + ($mapMaidMarshallingMapper == null ? 43 : ((Object)$mapMaidMarshallingMapper).hashCode());
        return result;
    }

    @Generated
    private MapMaidModule() {
    }
}

