/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.marshalling;

import de.quantummaid.httpmaid.HttpMaidChains;
import de.quantummaid.httpmaid.chains.ChainExtender;
import de.quantummaid.httpmaid.chains.ChainModule;
import de.quantummaid.httpmaid.handler.http.HttpRequest;
import de.quantummaid.httpmaid.http.headers.ContentType;
import de.quantummaid.httpmaid.marshalling.DefaultContentTypeProvider;
import de.quantummaid.httpmaid.marshalling.Marshaller;
import de.quantummaid.httpmaid.marshalling.Marshallers;
import de.quantummaid.httpmaid.marshalling.Unmarshaller;
import de.quantummaid.httpmaid.marshalling.Unmarshallers;
import de.quantummaid.httpmaid.marshalling.processors.MarshalProcessor;
import de.quantummaid.httpmaid.marshalling.processors.RegisterMarshallersProcessor;
import de.quantummaid.httpmaid.marshalling.processors.UnmarshalProcessor;
import de.quantummaid.httpmaid.util.Validators;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public final class MarshallingModule
implements ChainModule {
    private DefaultContentTypeProvider defaultContentTypeProvider;
    private final Map<ContentType, Unmarshaller> unmarshallersMap;
    private final Map<ContentType, Marshaller> marshallersMap;
    private boolean throwExceptionIfNoMarshallerFound;

    public static MarshallingModule emptyMarshallingModule() {
        return new MarshallingModule(new HashMap<ContentType, Unmarshaller>(), new HashMap<ContentType, Marshaller>());
    }

    public void addUnmarshaller(ContentType contentType, Unmarshaller unmarshaller) {
        Validators.validateNotNull(contentType, "contentType");
        Validators.validateNotNull(unmarshaller, "unmarshaller");
        this.unmarshallersMap.put(contentType, unmarshaller);
        if (this.defaultContentTypeProvider == null) {
            this.setDefaultContentTypeProvider(contentType);
        }
    }

    public void addMarshaller(ContentType contentType, Marshaller marshaller) {
        Validators.validateNotNull(contentType, "contentType");
        Validators.validateNotNull(marshaller, "marshaller");
        this.marshallersMap.put(contentType, marshaller);
        if (this.defaultContentTypeProvider == null) {
            this.setDefaultContentTypeProvider(contentType);
        }
    }

    public void setDefaultContentTypeProvider(ContentType defaultContentTypeProvider) {
        Validators.validateNotNull(defaultContentTypeProvider, "defaultContentType");
        this.setDefaultContentTypeProvider((HttpRequest request) -> defaultContentTypeProvider);
    }

    public void setDefaultContentTypeProvider(DefaultContentTypeProvider defaultContentType) {
        Validators.validateNotNull(defaultContentType, "defaultContentType");
        this.defaultContentTypeProvider = defaultContentType;
    }

    public void setThrowExceptionIfNoMarshallerFound(boolean throwExceptionIfNoMarshallerFound) {
        this.throwExceptionIfNoMarshallerFound = throwExceptionIfNoMarshallerFound;
    }

    @Override
    public void register(ChainExtender extender) {
        Unmarshallers unmarshallers = Unmarshallers.unmarshallers(this.unmarshallersMap);
        extender.appendProcessor(HttpMaidChains.PROCESS_BODY_STRING, UnmarshalProcessor.unmarshalProcessor(unmarshallers, this.throwExceptionIfNoMarshallerFound, this.defaultContentTypeProvider));
        Marshallers marshallers = Marshallers.marshallers(this.marshallersMap, this.defaultContentTypeProvider);
        extender.prependProcessor(HttpMaidChains.POST_INVOKE, MarshalProcessor.marshalProcessor(marshallers, this.throwExceptionIfNoMarshallerFound));
        extender.appendProcessor(HttpMaidChains.INIT, RegisterMarshallersProcessor.registerDefaultMarshallerProcessor(marshallers));
    }

    @Generated
    public String toString() {
        return "MarshallingModule(defaultContentTypeProvider=" + this.defaultContentTypeProvider + ", unmarshallersMap=" + this.unmarshallersMap + ", marshallersMap=" + this.marshallersMap + ", throwExceptionIfNoMarshallerFound=" + this.throwExceptionIfNoMarshallerFound + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MarshallingModule)) {
            return false;
        }
        MarshallingModule other = (MarshallingModule)o;
        if (this.throwExceptionIfNoMarshallerFound != other.throwExceptionIfNoMarshallerFound) {
            return false;
        }
        DefaultContentTypeProvider this$defaultContentTypeProvider = this.defaultContentTypeProvider;
        DefaultContentTypeProvider other$defaultContentTypeProvider = other.defaultContentTypeProvider;
        if (this$defaultContentTypeProvider == null ? other$defaultContentTypeProvider != null : !this$defaultContentTypeProvider.equals(other$defaultContentTypeProvider)) {
            return false;
        }
        Map<ContentType, Unmarshaller> this$unmarshallersMap = this.unmarshallersMap;
        Map<ContentType, Unmarshaller> other$unmarshallersMap = other.unmarshallersMap;
        if (this$unmarshallersMap == null ? other$unmarshallersMap != null : !((Object)this$unmarshallersMap).equals(other$unmarshallersMap)) {
            return false;
        }
        Map<ContentType, Marshaller> this$marshallersMap = this.marshallersMap;
        Map<ContentType, Marshaller> other$marshallersMap = other.marshallersMap;
        return !(this$marshallersMap == null ? other$marshallersMap != null : !((Object)this$marshallersMap).equals(other$marshallersMap));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.throwExceptionIfNoMarshallerFound ? 79 : 97);
        DefaultContentTypeProvider $defaultContentTypeProvider = this.defaultContentTypeProvider;
        result = result * 59 + ($defaultContentTypeProvider == null ? 43 : $defaultContentTypeProvider.hashCode());
        Map<ContentType, Unmarshaller> $unmarshallersMap = this.unmarshallersMap;
        result = result * 59 + ($unmarshallersMap == null ? 43 : ((Object)$unmarshallersMap).hashCode());
        Map<ContentType, Marshaller> $marshallersMap = this.marshallersMap;
        result = result * 59 + ($marshallersMap == null ? 43 : ((Object)$marshallersMap).hashCode());
        return result;
    }

    @Generated
    private MarshallingModule(Map<ContentType, Unmarshaller> unmarshallersMap, Map<ContentType, Marshaller> marshallersMap) {
        this.unmarshallersMap = unmarshallersMap;
        this.marshallersMap = marshallersMap;
    }
}

