/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.util;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class Maps {
    private Maps() {
    }

    public static <K, V> Optional<V> getOptionally(Map<K, V> map, K key) {
        if (!map.containsKey(key)) {
            return Optional.empty();
        }
        return Optional.of(map.get(key));
    }

    public static <K, V> Map<K, V> stringsToValueObjects(Map<String, String> map, Function<String, K> keyMapper, Function<String, V> valueMapper) {
        return Maps.transformMap(map, keyMapper, valueMapper);
    }

    public static <K, V> Map<String, String> valueObjectsToStrings(Map<K, V> map, Function<K, String> keyMapper, Function<V, String> valueMapper) {
        return Maps.transformMap(map, keyMapper, valueMapper);
    }

    public static <A, B> Map<A, List<B>> mapToMultiMap(Map<A, B> map) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Collections.singletonList(entry.getValue())));
    }

    public static <A, B, Y, Z> Map<Y, Z> transformMap(Map<A, B> map, Function<A, Y> keyMapper, Function<B, Z> valueMapper) {
        return map.entrySet().stream().collect(Collectors.toMap(entry -> keyMapper.apply(entry.getKey()), entry -> valueMapper.apply(entry.getValue())));
    }
}

