/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets.disconnect;

import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.websockets.criteria.WebsocketCriteria;
import de.quantummaid.httpmaid.websockets.registry.ConnectionInformation;
import de.quantummaid.httpmaid.websockets.registry.WebsocketRegistry;
import de.quantummaid.httpmaid.websockets.registry.WebsocketRegistryEntry;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSender;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSenderId;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSenders;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Disconnector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Disconnector.class);
    private final WebsocketRegistry websocketRegistry;
    private final WebsocketSenders websocketSenders;
    private final MetaData metaData;

    public static Disconnector disconnector(WebsocketRegistry websocketRegistry, WebsocketSenders websocketSenders, MetaData metaData) {
        return new Disconnector(websocketRegistry, websocketSenders, metaData);
    }

    public void disconnectAll() {
        this.disconnectAllThat(WebsocketCriteria.websocketCriteria());
    }

    public void disconnectAllThat(WebsocketCriteria criteria) {
        Validators.validateNotNull(criteria, "criteria");
        List<WebsocketRegistryEntry> connections = this.websocketRegistry.connections(criteria);
        Map<WebsocketSenderId, List<WebsocketRegistryEntry>> bySenderId = connections.stream().collect(Collectors.groupingBy(WebsocketRegistryEntry::getSenderId));
        bySenderId.forEach((websocketSenderId, websocketRegistryEntries) -> {
            websocketRegistryEntries.forEach(entry -> {
                log.info("removing websocket from registry because it has been closed by the server; websocket: {}; request metadata: {}", entry, (Object)this.metaData);
                this.websocketRegistry.removeConnection(entry.connectionInformation());
            });
            WebsocketSender<ConnectionInformation> sender = this.websocketSenders.senderById((WebsocketSenderId)websocketSenderId);
            List connectionInformations = websocketRegistryEntries.stream().map(WebsocketRegistryEntry::connectionInformation).collect(Collectors.toList());
            sender.disconnect(connectionInformations, (connectionInformation, throwable) -> log.info("exception when disconnecting websocket {}; request metadata: {}.", connectionInformation, this.metaData, throwable));
        });
    }

    @Generated
    private Disconnector(WebsocketRegistry websocketRegistry, WebsocketSenders websocketSenders, MetaData metaData) {
        this.websocketRegistry = websocketRegistry;
        this.websocketSenders = websocketSenders;
        this.metaData = metaData;
    }
}

