/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.injectmaid;

import de.quantummaid.injectmaid.Definition;
import de.quantummaid.injectmaid.Definitions;
import de.quantummaid.injectmaid.InjectMaid;
import de.quantummaid.injectmaid.InjectMaidException;
import de.quantummaid.injectmaid.Scope;
import de.quantummaid.injectmaid.Scopes;
import de.quantummaid.injectmaid.api.AbstractInjectorBuilder;
import de.quantummaid.injectmaid.api.InjectorConfiguration;
import de.quantummaid.injectmaid.api.ReusePolicy;
import de.quantummaid.injectmaid.api.SingletonType;
import de.quantummaid.injectmaid.api.customtype.CustomTypeInstantiator;
import de.quantummaid.injectmaid.api.customtype.api.CustomType;
import de.quantummaid.injectmaid.api.customtype.api.CustomTypeData;
import de.quantummaid.injectmaid.instantiator.BindInstantiator;
import de.quantummaid.injectmaid.instantiator.Instantiator;
import de.quantummaid.injectmaid.instantiator.ScopeInstantiator;
import de.quantummaid.injectmaid.lifecyclemanagement.LifecycleManager;
import de.quantummaid.injectmaid.lifecyclemanagement.NoOpLifecycleManager;
import de.quantummaid.injectmaid.lifecyclemanagement.RealLifecycleManager;
import de.quantummaid.injectmaid.lifecyclemanagement.closer.CloseFunction;
import de.quantummaid.injectmaid.lifecyclemanagement.closer.Closer;
import de.quantummaid.injectmaid.lifecyclemanagement.closer.Closers;
import de.quantummaid.injectmaid.statemachine.Context;
import de.quantummaid.injectmaid.statemachine.StateMachineRunner;
import de.quantummaid.injectmaid.statemachine.States;
import de.quantummaid.injectmaid.statemachine.states.ResolvingDependencies;
import de.quantummaid.injectmaid.statemachine.states.State;
import de.quantummaid.injectmaid.statemachine.states.Unresolved;
import de.quantummaid.injectmaid.statemachine.states.UnresolvedFactory;
import de.quantummaid.reflectmaid.ResolvedType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public final class InjectMaidBuilder
implements AbstractInjectorBuilder<InjectMaidBuilder> {
    private static final ReusePolicy DEFAULT_REUSE_POLICY = ReusePolicy.PROTOTYPE;
    private boolean registerShutdownHook = false;
    private final States states;
    private final Scope scope;
    private final Scopes scopes;
    private SingletonType defaultSingletonType = SingletonType.LAZY;
    private boolean lifecycleManagement = false;
    private final List<Closer> closers = new ArrayList<Closer>();

    static InjectMaidBuilder injectionMaidBuilder() {
        States states = States.states();
        Scope scope = Scope.rootScope();
        Scopes scopes = Scopes.scopes();
        scopes.add(scope);
        return new InjectMaidBuilder(states, scope, scopes);
    }

    @Override
    public InjectMaidBuilder withConfiguration(InjectorConfiguration configuration) {
        configuration.apply(this);
        return this;
    }

    @Override
    public InjectMaidBuilder withScope(ResolvedType scopeType, InjectorConfiguration configuration) {
        this.scopes.validateElementNotUsedSomewhereElse(scopeType, this.scope);
        Scope subScope = this.scope.childScope(scopeType);
        InjectMaidBuilder scopedBuilder = new InjectMaidBuilder(this.states, subScope, this.scopes);
        scopedBuilder.lifecycleManagement = this.lifecycleManagement;
        if (!this.scopes.contains(subScope)) {
            ScopeInstantiator scopeInstantiator = ScopeInstantiator.scopeInstantiator(scopeType);
            scopedBuilder.withInstantiator(scopeType, scopeInstantiator, DEFAULT_REUSE_POLICY);
        }
        this.scopes.add(subScope);
        configuration.apply(scopedBuilder);
        return this;
    }

    public InjectMaidBuilder withLifecycleManagement() {
        this.lifecycleManagement = true;
        return this;
    }

    @Override
    public InjectMaidBuilder withFactory(ResolvedType type, ResolvedType factory, ReusePolicy reusePolicy) {
        Context context = Context.context(type, this.scope, this.states, reusePolicy);
        UnresolvedFactory state = UnresolvedFactory.unresolvedFactory(context, factory);
        this.states.addOrFailIfAlreadyPresent(state, false);
        return this;
    }

    @Override
    public InjectMaidBuilder withImplementation(ResolvedType interfaceType, ResolvedType implementationType, ReusePolicy reusePolicy) {
        Context context = Context.context(interfaceType, this.scope, this.states, DEFAULT_REUSE_POLICY);
        BindInstantiator instantiator = BindInstantiator.bindInstantiator(implementationType);
        context.setInstantiator(instantiator);
        ResolvingDependencies state = ResolvingDependencies.resolvingDependencies(context);
        this.states.addOrFailIfAlreadyPresent(state, false);
        return this.withType(implementationType, reusePolicy, true);
    }

    @Override
    public InjectMaidBuilder withType(ResolvedType resolvedType, ReusePolicy reusePolicy) {
        return this.withType(resolvedType, reusePolicy, false);
    }

    private InjectMaidBuilder withType(ResolvedType resolvedType, ReusePolicy reusePolicy, boolean allowDuplicatesIfSame) {
        Context context = Context.context(resolvedType, this.scope, this.states, reusePolicy);
        State state = Unresolved.unresolved(context);
        this.states.addOrFailIfAlreadyPresent(state, allowDuplicatesIfSame);
        return this;
    }

    @Override
    public InjectMaidBuilder withCustomType(CustomType customType, ReusePolicy reusePolicy) {
        ResolvedType type = customType.resolvedType();
        CustomTypeData customTypeData = customType.instantiator();
        CustomTypeInstantiator instantiator = CustomTypeInstantiator.customTypeInstantiator(customTypeData.dependencies(), customTypeData.invocableFactory());
        return this.withInstantiator(type, instantiator, reusePolicy);
    }

    @Override
    public InjectMaidBuilder usingDefaultSingletonType(SingletonType singletonType) {
        this.defaultSingletonType = singletonType;
        return this;
    }

    public InjectMaidBuilder withInstantiator(ResolvedType resolvedType, Instantiator instantiator, ReusePolicy reusePolicy) {
        Context context = Context.context(resolvedType, this.scope, this.states, reusePolicy);
        context.setInstantiator(instantiator);
        ResolvingDependencies state = ResolvingDependencies.resolvingDependencies(context);
        this.states.addOrFailIfAlreadyPresent(state, false);
        return this;
    }

    public <T> InjectMaidBuilder closingInstancesOfType(Class<T> type, CloseFunction<T> closeFunction) {
        this.closers.add(Closer.closer(type, closeFunction));
        return this;
    }

    public InjectMaidBuilder closeOnJvmShutdown() {
        this.registerShutdownHook = true;
        return this;
    }

    public InjectMaid build() {
        LifecycleManager lifecycleManager;
        Map<ResolvedType, List<Definition>> definitionsMap = StateMachineRunner.runStateMachine(this.states);
        Definitions definitions = Definitions.definitions(this.scopes.asList(), definitionsMap);
        if (this.lifecycleManagement || !this.closers.isEmpty()) {
            this.closers.add(Closer.closer(AutoCloseable.class, AutoCloseable::close));
            lifecycleManager = RealLifecycleManager.realLifecycleManager(Closers.closers(this.closers), this.scope);
        } else {
            lifecycleManager = NoOpLifecycleManager.noOpLifecycleManager();
        }
        InjectMaid injectMaid = InjectMaid.injectMaid(definitions, this.defaultSingletonType, lifecycleManager);
        if (this.registerShutdownHook) {
            if (!this.lifecycleManagement) {
                throw InjectMaidException.injectMaidException("can only close on JVM shutdown if lifecycle management is activated");
            }
            injectMaid.registerShutdownHook();
        }
        return injectMaid;
    }

    @Generated
    private InjectMaidBuilder(States states, Scope scope, Scopes scopes) {
        this.states = states;
        this.scope = scope;
        this.scopes = scopes;
    }
}

