/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.injectmaid.detection.disambiguators;

import de.quantummaid.injectmaid.detection.InstantiationOptions;
import de.quantummaid.injectmaid.detection.disambiguators.DisambiguationResult;
import de.quantummaid.injectmaid.detection.disambiguators.Disambiguator;
import de.quantummaid.injectmaid.instantiator.ConstructorInstantiator;
import de.quantummaid.injectmaid.instantiator.Instantiator;
import de.quantummaid.injectmaid.instantiator.NonStaticFactoryInstantiator;
import de.quantummaid.injectmaid.instantiator.StaticFactoryInstantiator;
import java.util.List;
import lombok.Generated;

public final class SingleChoiceDisambiguator
implements Disambiguator {
    public static SingleChoiceDisambiguator singleChoiceDisambiguator() {
        return new SingleChoiceDisambiguator();
    }

    @Override
    public DisambiguationResult disambiguate(InstantiationOptions instantiationOptions) {
        List<ConstructorInstantiator> constructors = instantiationOptions.constructors();
        List<StaticFactoryInstantiator> staticFactoryMethods = instantiationOptions.staticFactoryMethods();
        List<NonStaticFactoryInstantiator> nonStaticFactoryMethods = instantiationOptions.nonStaticFactoryMethods();
        int combinedSize = constructors.size() + staticFactoryMethods.size() + nonStaticFactoryMethods.size();
        if (combinedSize == 0) {
            return DisambiguationResult.ignore("No public constructors or static factory methods found");
        }
        if (combinedSize > 1) {
            return DisambiguationResult.ignore("More than one public constructors or factory methods found");
        }
        Instantiator instantiator = !constructors.isEmpty() ? (Instantiator)constructors.get(0) : (!staticFactoryMethods.isEmpty() ? (Instantiator)staticFactoryMethods.get(0) : (Instantiator)nonStaticFactoryMethods.get(0));
        return DisambiguationResult.success(instantiator);
    }

    @Generated
    public String toString() {
        return "SingleChoiceDisambiguator()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof SingleChoiceDisambiguator;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    private SingleChoiceDisambiguator() {
    }
}

