/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.injectmaid.timing;

import de.quantummaid.injectmaid.InjectMaidException;
import de.quantummaid.injectmaid.timing.InstantiationTime;
import de.quantummaid.reflectmaid.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class InstantiationTimes {
    private final Map<GenericType<?>, InstantiationTime> instantiationTimes = new HashMap();

    public static InstantiationTimes instantiationTimes() {
        return new InstantiationTimes();
    }

    public void addInitializationTime(GenericType<?> type, InstantiationTime time) {
        this.instantiationTimes.put(type, time);
    }

    public InstantiationTime initializationTimeFor(Class<?> type) {
        GenericType<?> genericType = GenericType.genericType(type);
        return this.initializationTimeFor(genericType);
    }

    public InstantiationTime initializationTimeFor(GenericType<?> genericType) {
        if (!this.instantiationTimes.containsKey(genericType)) {
            throw InjectMaidException.injectMaidException(String.format("no instantiation time available for %s", genericType.toResolvedType().description()));
        }
        return this.instantiationTimes.get(genericType);
    }

    public List<InstantiationTime> allInstantiationTimes() {
        return new ArrayList<InstantiationTime>(this.instantiationTimes.values());
    }

    public String render() {
        return this.instantiationTimes.values().stream().map(InstantiationTime::render).collect(Collectors.joining("\n"));
    }
}

