/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.recipes.urlencoded;

import de.quantummaid.mapmaid.builder.recipes.urlencoded.Key;
import de.quantummaid.mapmaid.builder.recipes.urlencoded.KeyElement;
import de.quantummaid.mapmaid.builder.recipes.urlencoded.ParsedUrlEncoded;
import de.quantummaid.mapmaid.mapper.marshalling.string.StringUnmarshaller;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public final class UrlEncodedUnmarshaller
implements StringUnmarshaller {
    public static UrlEncodedUnmarshaller urlEncodedUnmarshaller() {
        return new UrlEncodedUnmarshaller();
    }

    private static boolean areArrayIndeces(List<KeyElement> indeces) {
        return indeces.stream().anyMatch(KeyElement::isArrayIndex);
    }

    @Override
    public Object unmarshalString(String input) {
        ParsedUrlEncoded parsed = ParsedUrlEncoded.parse(input);
        return this.parseFromKey(Key.emptyKey(), parsed);
    }

    private Object parseFromKey(Key key, ParsedUrlEncoded parsed) {
        return parsed.getValue(key).map(Object.class::cast).orElseGet(() -> this.parseArrayOrMap(key, parsed));
    }

    private Object parseArrayOrMap(Key key, ParsedUrlEncoded parsed) {
        List<KeyElement> children = parsed.directChildren(key);
        if (UrlEncodedUnmarshaller.areArrayIndeces(children)) {
            return this.parseArray(key, children, parsed);
        }
        return this.parseMap(key, children, parsed);
    }

    private List<Object> parseArray(Key key, List<KeyElement> children, ParsedUrlEncoded parsed) {
        ArrayList<Object> list = new ArrayList<Object>(children.size());
        children.forEach(child -> {
            Object childValue = this.parseFromKey(key.child((KeyElement)child), parsed);
            list.add(child.asArrayIndex(), childValue);
        });
        return list;
    }

    private Map<String, Object> parseMap(Key key, List<KeyElement> children, ParsedUrlEncoded parsed) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        children.forEach(child -> {
            Object childValue = this.parseFromKey(key.child((KeyElement)child), parsed);
            map.put(child.value(), childValue);
        });
        return map;
    }

    @Generated
    public String toString() {
        return "UrlEncodedUnmarshaller()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof UrlEncodedUnmarshaller;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    private UrlEncodedUnmarshaller() {
    }
}

