/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.resolving.disambiguator;

import de.quantummaid.mapmaid.debug.MapMaidException;
import de.quantummaid.mapmaid.debug.scaninformation.ScanInformation;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.TypeSerializer;
import de.quantummaid.reflectmaid.ResolvedType;
import java.util.List;
import lombok.Generated;

public final class SerializersAndDeserializers {
    private final List<TypeSerializer> serializers;
    private final List<TypeDeserializer> deserializers;

    public static SerializersAndDeserializers empty() {
        return new SerializersAndDeserializers(List.of(), List.of());
    }

    public static SerializersAndDeserializers serializersAndDeserializers(List<TypeSerializer> serializers, List<TypeDeserializer> deserializers) {
        return new SerializersAndDeserializers(serializers, deserializers);
    }

    public boolean hasSerializers() {
        return this.serializers != null;
    }

    public boolean hasDeserializers() {
        return this.deserializers != null;
    }

    public List<TypeSerializer> serializers(ResolvedType type) {
        if (!this.hasSerializers()) {
            throw MapMaidException.mapMaidException(String.format("no serializers detected for type %s - this should never happen", type.description()), new ScanInformation[0]);
        }
        return this.serializers;
    }

    public List<TypeDeserializer> deserializers(ResolvedType type) {
        if (!this.hasDeserializers()) {
            throw MapMaidException.mapMaidException(String.format("no deserializers detected for type %s - this should never happen", type.description()), new ScanInformation[0]);
        }
        return this.deserializers;
    }

    @Generated
    public String toString() {
        return "SerializersAndDeserializers(serializers=" + this.serializers + ", deserializers=" + this.deserializers + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SerializersAndDeserializers)) {
            return false;
        }
        SerializersAndDeserializers other = (SerializersAndDeserializers)o;
        List<TypeSerializer> this$serializers = this.serializers;
        List<TypeSerializer> other$serializers = other.serializers;
        if (this$serializers == null ? other$serializers != null : !((Object)this$serializers).equals(other$serializers)) {
            return false;
        }
        List<TypeDeserializer> this$deserializers = this.deserializers;
        List<TypeDeserializer> other$deserializers = other.deserializers;
        return !(this$deserializers == null ? other$deserializers != null : !((Object)this$deserializers).equals(other$deserializers));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<TypeSerializer> $serializers = this.serializers;
        result = result * 59 + ($serializers == null ? 43 : ((Object)$serializers).hashCode());
        List<TypeDeserializer> $deserializers = this.deserializers;
        result = result * 59 + ($deserializers == null ? 43 : ((Object)$deserializers).hashCode());
        return result;
    }

    @Generated
    private SerializersAndDeserializers(List<TypeSerializer> serializers, List<TypeDeserializer> deserializers) {
        this.serializers = serializers;
        this.deserializers = deserializers;
    }
}

