/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.symmetry.serializedobject;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class Combinations {
    private Combinations() {
    }

    public static <T> List<List<T>> allCombinations(List<T> requiredElements, List<T> optionalElements) {
        List<List<T>> powerSetOfOptionalElements = Combinations.recursivePowerSet(optionalElements);
        return powerSetOfOptionalElements.stream().map(optionalSubset -> Combinations.combine(requiredElements, optionalSubset)).collect(Collectors.toList());
    }

    private static <T> List<List<T>> recursivePowerSet(List<T> list) {
        if (list.isEmpty()) {
            return Collections.singletonList(list);
        }
        T element = list.iterator().next();
        List<T> withoutElement = Combinations.withoutElement(list, element);
        List<List<T>> powerSetSubSetWithoutElement = Combinations.recursivePowerSet(withoutElement);
        List<List<T>> powerSetSubSetWithElement = Combinations.addToAll(powerSetSubSetWithoutElement, element);
        return Combinations.combine(powerSetSubSetWithoutElement, powerSetSubSetWithElement);
    }

    private static <T> List<T> combine(List<T> a, List<T> b) {
        int size = a.size() + b.size();
        ArrayList<T> combination = new ArrayList<T>(size);
        combination.addAll(a);
        combination.addAll(b);
        return combination;
    }

    private static <T> List<List<T>> addToAll(List<List<T>> lists, T element) {
        return lists.stream().map(list -> Combinations.withElement(list, element)).collect(Collectors.toList());
    }

    private static <T> List<T> withoutElement(List<T> list, T element) {
        ArrayList<T> copy = new ArrayList<T>(list);
        copy.remove(element);
        return copy;
    }

    private static <T> List<T> withElement(List<T> list, T element) {
        ArrayList<T> copy = new ArrayList<T>(list);
        copy.add(element);
        return copy;
    }
}

