/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.tiebreaker;

import de.quantummaid.mapmaid.builder.detection.DetectionResult;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.tiebreaker.IrrefutableHint;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.tiebreaker.IrrefutableHints;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.tiebreaker.TieBreakingReason;
import de.quantummaid.mapmaid.builder.resolving.requirements.DetectionRequirements;
import de.quantummaid.mapmaid.debug.ScanInformationBuilder;
import de.quantummaid.mapmaid.mapper.MappingFunction;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.TypeSerializer;
import java.util.List;
import lombok.Generated;

public final class TieBreaker {
    private final IrrefutableHints<TypeSerializer> customPrimitiveSerializationHints;
    private final IrrefutableHints<TypeSerializer> serializedObjectSerializationHints;
    private final IrrefutableHints<TypeDeserializer> customPrimitiveDeserializationHints;
    private final IrrefutableHints<TypeDeserializer> serializedObjectDeserializationHints;

    public static TieBreaker tieBreaker(List<IrrefutableHint<TypeSerializer>> customPrimitiveSerializationHints, List<IrrefutableHint<TypeSerializer>> serializedObjectSerializationHints, List<IrrefutableHint<TypeDeserializer>> customPrimitiveDeserializationHints, List<IrrefutableHint<TypeDeserializer>> serializedObjectDeserializationHints) {
        return new TieBreaker(IrrefutableHints.irrefutableHints(customPrimitiveSerializationHints), IrrefutableHints.irrefutableHints(serializedObjectSerializationHints), IrrefutableHints.irrefutableHints(customPrimitiveDeserializationHints), IrrefutableHints.irrefutableHints(serializedObjectDeserializationHints));
    }

    public DetectionResult<TypeSerializer> breakTieForSerializationOnly(DetectionResult<TypeSerializer> customPrimitive, DetectionResult<TypeSerializer> serializedObject, ScanInformationBuilder scanInformationBuilder) {
        if (customPrimitive.isFailure() && serializedObject.isFailure()) {
            return DetectionResult.followUpFailure(customPrimitive, serializedObject);
        }
        DetectionRequirements detectionRequirements = scanInformationBuilder.detectionRequirements();
        TieBreakingReason customPrimitiveBreaking = !customPrimitive.isFailure() ? this.customPrimitiveSerializationHints.isTieBreaking(customPrimitive.result(), detectionRequirements) : TieBreakingReason.notATieBreakingReason();
        TieBreakingReason serializedObjectBreaking = !serializedObject.isFailure() ? this.serializedObjectSerializationHints.isTieBreaking(serializedObject.result(), detectionRequirements) : TieBreakingReason.notATieBreakingReason();
        if (customPrimitiveBreaking.isTieBreaking() && serializedObjectBreaking.isTieBreaking()) {
            String explanation = String.format("Unable to choose between serialized object and custom primitive%n\tSerialized Object serializer: %s%n\tPrioritized because: %s%n\tCustom Primitive serializer: %s%n\tPrioritized because: %s%n", serializedObject.result().description(), serializedObjectBreaking.getReason(), customPrimitive.result().description(), customPrimitiveBreaking.getReason());
            return DetectionResult.failure(explanation);
        }
        return TieBreaker.breakTie(customPrimitiveBreaking, serializedObjectBreaking, scanInformationBuilder, customPrimitive, serializedObject);
    }

    public DetectionResult<TypeDeserializer> breakTieForDeserializationOnly(DetectionResult<TypeDeserializer> customPrimitive, DetectionResult<TypeDeserializer> serializedObject, ScanInformationBuilder scanInformationBuilder) {
        if (customPrimitive.isFailure() && serializedObject.isFailure()) {
            return DetectionResult.followUpFailure(customPrimitive, serializedObject);
        }
        DetectionRequirements detectionRequirements = scanInformationBuilder.detectionRequirements();
        TieBreakingReason customPrimitiveBreaking = !customPrimitive.isFailure() ? this.customPrimitiveDeserializationHints.isTieBreaking(customPrimitive.result(), detectionRequirements) : TieBreakingReason.notATieBreakingReason();
        TieBreakingReason serializedObjectBreaking = !serializedObject.isFailure() ? this.serializedObjectDeserializationHints.isTieBreaking(serializedObject.result(), detectionRequirements) : TieBreakingReason.notATieBreakingReason();
        if (customPrimitiveBreaking.isTieBreaking() && serializedObjectBreaking.isTieBreaking()) {
            String explanation = String.format("Unable to choose between serialized object and custom primitive%n\tSerialized Object deserializer: %s%n\tPrioritized because: %s%n\tCustom Primitive deserializer: %s%n\tPrioritized because: %s%n", serializedObject.result().description(), serializedObjectBreaking.getReason(), customPrimitive.result().description(), customPrimitiveBreaking.getReason());
            return DetectionResult.failure(explanation);
        }
        return TieBreaker.breakTie(customPrimitiveBreaking, serializedObjectBreaking, scanInformationBuilder, customPrimitive, serializedObject);
    }

    private static <T extends MappingFunction> DetectionResult<T> breakTie(TieBreakingReason customPrimitiveBreaking, TieBreakingReason serializedObjectBreaking, ScanInformationBuilder scanInformationBuilder, DetectionResult<T> customPrimitive, DetectionResult<T> serializedObject) {
        if (customPrimitiveBreaking.isTieBreaking()) {
            serializedObject.ifSuccess(deserializer -> {
                String reason = String.format("custom primitive has been preferred because: %s", customPrimitiveBreaking.getReason());
                scanInformationBuilder.ignore(deserializer, reason);
            });
            return customPrimitive;
        }
        if (serializedObjectBreaking.isTieBreaking()) {
            customPrimitive.ifSuccess(deserializer -> {
                String reason = String.format("serialized object has been preferred because: %s", serializedObjectBreaking.getReason());
                scanInformationBuilder.ignore(deserializer, reason);
            });
            return serializedObject;
        }
        if (customPrimitive.isSuccess()) {
            if (serializedObject.isSuccess() && ((MappingFunction)serializedObject.result()).numberOfParameters() > 1) {
                customPrimitive.ifSuccess(deserializer -> scanInformationBuilder.ignore(deserializer, "serialized object has been preferred because it has multiple parameters"));
                return serializedObject;
            }
            serializedObject.ifSuccess(deserializer -> scanInformationBuilder.ignore(deserializer, "custom primitive has been preferred"));
            return customPrimitive;
        }
        return serializedObject;
    }

    @Generated
    public String toString() {
        return "TieBreaker(customPrimitiveSerializationHints=" + this.customPrimitiveSerializationHints + ", serializedObjectSerializationHints=" + this.serializedObjectSerializationHints + ", customPrimitiveDeserializationHints=" + this.customPrimitiveDeserializationHints + ", serializedObjectDeserializationHints=" + this.serializedObjectDeserializationHints + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TieBreaker)) {
            return false;
        }
        TieBreaker other = (TieBreaker)o;
        IrrefutableHints<TypeSerializer> this$customPrimitiveSerializationHints = this.customPrimitiveSerializationHints;
        IrrefutableHints<TypeSerializer> other$customPrimitiveSerializationHints = other.customPrimitiveSerializationHints;
        if (this$customPrimitiveSerializationHints == null ? other$customPrimitiveSerializationHints != null : !((Object)this$customPrimitiveSerializationHints).equals(other$customPrimitiveSerializationHints)) {
            return false;
        }
        IrrefutableHints<TypeSerializer> this$serializedObjectSerializationHints = this.serializedObjectSerializationHints;
        IrrefutableHints<TypeSerializer> other$serializedObjectSerializationHints = other.serializedObjectSerializationHints;
        if (this$serializedObjectSerializationHints == null ? other$serializedObjectSerializationHints != null : !((Object)this$serializedObjectSerializationHints).equals(other$serializedObjectSerializationHints)) {
            return false;
        }
        IrrefutableHints<TypeDeserializer> this$customPrimitiveDeserializationHints = this.customPrimitiveDeserializationHints;
        IrrefutableHints<TypeDeserializer> other$customPrimitiveDeserializationHints = other.customPrimitiveDeserializationHints;
        if (this$customPrimitiveDeserializationHints == null ? other$customPrimitiveDeserializationHints != null : !((Object)this$customPrimitiveDeserializationHints).equals(other$customPrimitiveDeserializationHints)) {
            return false;
        }
        IrrefutableHints<TypeDeserializer> this$serializedObjectDeserializationHints = this.serializedObjectDeserializationHints;
        IrrefutableHints<TypeDeserializer> other$serializedObjectDeserializationHints = other.serializedObjectDeserializationHints;
        return !(this$serializedObjectDeserializationHints == null ? other$serializedObjectDeserializationHints != null : !((Object)this$serializedObjectDeserializationHints).equals(other$serializedObjectDeserializationHints));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IrrefutableHints<TypeSerializer> $customPrimitiveSerializationHints = this.customPrimitiveSerializationHints;
        result = result * 59 + ($customPrimitiveSerializationHints == null ? 43 : ((Object)$customPrimitiveSerializationHints).hashCode());
        IrrefutableHints<TypeSerializer> $serializedObjectSerializationHints = this.serializedObjectSerializationHints;
        result = result * 59 + ($serializedObjectSerializationHints == null ? 43 : ((Object)$serializedObjectSerializationHints).hashCode());
        IrrefutableHints<TypeDeserializer> $customPrimitiveDeserializationHints = this.customPrimitiveDeserializationHints;
        result = result * 59 + ($customPrimitiveDeserializationHints == null ? 43 : ((Object)$customPrimitiveDeserializationHints).hashCode());
        IrrefutableHints<TypeDeserializer> $serializedObjectDeserializationHints = this.serializedObjectDeserializationHints;
        result = result * 59 + ($serializedObjectDeserializationHints == null ? 43 : ((Object)$serializedObjectDeserializationHints).hashCode());
        return result;
    }

    @Generated
    private TieBreaker(IrrefutableHints<TypeSerializer> customPrimitiveSerializationHints, IrrefutableHints<TypeSerializer> serializedObjectSerializationHints, IrrefutableHints<TypeDeserializer> customPrimitiveDeserializationHints, IrrefutableHints<TypeDeserializer> serializedObjectDeserializationHints) {
        this.customPrimitiveSerializationHints = customPrimitiveSerializationHints;
        this.serializedObjectSerializationHints = serializedObjectSerializationHints;
        this.customPrimitiveDeserializationHints = customPrimitiveDeserializationHints;
        this.serializedObjectDeserializationHints = serializedObjectDeserializationHints;
    }
}

